<?php

declare(strict_types=1);

namespace Clientexec\Utils;

use Egulias\EmailValidator\EmailValidator;
use Egulias\EmailValidator\Validation\RFCValidation;
use InvalidArgumentException;
use LogicException;

class AvatarBio
{
    private string $url = 'https://avatar.clientexec.rocks/avatar/';
    private string $backGroundColor = 'DAF1FF';
    private string $textColor = '555555';
    private string $text = '';
    private int $size = 40;
    private string $email = '';

    private EmailValidator $validator;

    public function __construct()
    {
        $this->validator = new EmailValidator();
    }

    public function getSiteUrl(): string
    {
        return $this->url;
    }

    public function setEmail(string $email): void
    {
        $email = trim($email);

        if (! $this->validator->isValid($email, new RFCValidation())) {
            throw new InvalidArgumentException('Invalid Email Address: ' . $email);
        }

        $this->email = $email;
    }

    public function getEmail(): string
    {
        return $this->email;
    }

    public function setSize(int $size): void
    {
        $this->size = $size;
    }

    public function getSize(): int
    {
        return $this->size;
    }

    public function getBackGroundColor(): string
    {
        return $this->backGroundColor;
    }

    public function setBackGroundColor(string $color): void
    {
        $this->backGroundColor = $color;
    }

    public function getTextColor(): string
    {
        return $this->textColor;
    }

    public function setTextColor(string $color): void
    {
        $this->textColor = $color;
    }

    public function setText(string $text): void
    {
        $this->text = trim($text);
    }

    public function getText(): string
    {
        return $this->text;
    }

    /**
     * Return the Avatar.bio image URL based on the provided email address
     */
    public function getImageUrl(): string
    {
        if ($this->email === '') {
            throw new LogicException('No email address has been provided');
        }

        $url = $this->url
            . $this->email
            . '?bc=' . $this->backGroundColor
            . '&tc=' . $this->textColor
            . '&s=' . $this->size;

        if ($this->text !== '') {
            $url .= '&t=' . rawurlencode($this->text);
        }

        return $url;
    }
}
