<?php

/**
 * Clients Menu Hooks class
 *
 * @package Clients
 */
class Clients_menu extends NE_MenuHook
{
    public $width = "346px;";
    public $offset = "-250px;";
    public $direction = "left";
    public $snapin_key = "second";

    /**
     * function which display the client menus
     *
     * @param object &$user     user reference
     * @param object &$customer customer reference
     *
     * @return void
     */
    public function __construct($user)
    {

        if (CE_Lib::affiliateSystem()) {
            $this->width = "530px;";
            $this->offset = "-422px;";
        }


        if ($user->hasPermission("admin_edit_announcements") || $user->hasPermission("admin_edit_notifications")) {
            //contact users
            $menuItem = new NE_MenuItem($user->lang("Contact Users"), "#");
            $menuItem->addViews(array('adminviewnotifications','adminviewannouncements'));
            $menuItem->addPermissions('clients_view_domains');
            $subMenu = new NE_MenuHook($user);

            if ($user->hasPermission("admin_edit_notifications")) {
                $submenuItem = new NE_MenuItem($user->lang("Notifications"), "index.php?fuse=admin&controller=notifications&view=adminviewnotifications");
                $submenuItem->addViews('adminviewnotifications');
                $subMenu->addItem($submenuItem);
            }


            if ($user->hasPermission("admin_edit_announcements")) {
                $submenuItem = new NE_MenuItem($user->lang('Announcements'), "index.php?fuse=admin&amp;view=adminviewannouncements&amp;controller=announcements");
                $submenuItem->addViews('adminviewannouncements');
                $subMenu->addItem($submenuItem);
            }

            $menuItem->addSubmenu($subMenu);
            $this->addItem($menuItem);
        }

        //Client List
        $menuItem = new NE_MenuItem($user->lang("Clients"), "index.php?fuse=clients&controller=user&view=viewusers");
        $menuItem->addViews(array('viewpending','profileevents','ShowEmail','viewusers','profilecontact','profileaccounts','profilepassword','profilebilling','profilerecurringcharges','profilenotes','profiledomains','profileproducts','profileproduct','profileinvoices','profileuninvoiced','ViewMergeClient'));
        $menuItem->addPermissions('clients_view_customers');

        $subMenu = new NE_MenuHook($user);
        include_once 'library/CE/NE_GroupsGateway.php';
        //get all customer groups
        $groupsGateway = new NE_GroupsGateway();
        $groupsIt = $groupsGateway->getCustomerGroups();
        $submenuItem = new NE_MenuItem($user->lang("Pending Orders"), "index.php?fuse=clients&amp;view=viewpending&controller=orders");
        $submenuItem->addViews('viewpending');
        $subMenu->addItem($submenuItem);

        $submenuItem = new NE_MenuItem($user->lang("All Clients"), "index.php?fuse=clients&controller=user&view=viewusers");
        $submenuItem->addViews('viewusers');
        $submenuItem->addActiveParam('group_id', '');
        $subMenu->addItem($submenuItem);

        $top10Groups = $groupsGateway->getTopGroups(10);

        while ($group = $groupsIt->fetch()) {
            if (isset($top10Groups[$group->getId()])) {
                $top10Groups[$group->getId()] = $group;
            }
        }

        foreach ($top10Groups as $group) {
            if (is_object($group)) {
                $groupname = $group->getName();
                if (strlen($groupname) > 17) {
                    $groupname = substr($groupname, 0, 17) . "...";
                }
                $submenuItem = new NE_MenuItem($groupname, "index.php?fuse=clients&controller=user&view=viewusers&group_id=" . $group->getId());
                $submenuItem->addActiveParam('group_id', $group->getId());
                $submenuItem->addViews('viewusers');
                $subMenu->addItem($submenuItem);
            }
        }


        $menuItem->addSubmenu($subMenu);
        $this->addItem($menuItem);

        if ($user->hasPermission('clients_view_emails')) {
            $menuItem = new NE_MenuItem($user->lang('View Emails'), "index.php?fuse=clients&controller=email&view=list");
            $menuItem->addPermissions('clients_view_emails');
            $this->addItem($menuItem);
        }

        //packages
        $menuItem = new NE_MenuItem($user->lang("Packages"), "index.php?fuse=clients&controller=packages&view=hostingpackagelist");
        $menuItem->addViews(array('hostingpackagelist','domainslist','generalpackageslist', 'sslpackagelist'));
        $menuItem->addPermissions('clients_view_domains');

        $subMenu = new NE_MenuHook($user);
        $submenuItem = new NE_MenuItem($user->lang("Hosting Packages"), "index.php?fuse=clients&controller=packages&view=hostingpackagelist");
        $submenuItem->addViews('hostingpackagelist');
        $subMenu->addItem($submenuItem);

        $submenuItem = new NE_MenuItem($user->lang("Domain Packages"), "index.php?fuse=clients&controller=packages&view=domainslist");
        $submenuItem->addViews('domainslist');
        $subMenu->addItem($submenuItem);

        $submenuItem = new NE_MenuItem($user->lang("General Packages"), "index.php?fuse=clients&controller=packages&view=generalpackageslist");
        $submenuItem->addViews('generalpackageslist');
        $subMenu->addItem($submenuItem);

        $submenuItem = new NE_MenuItem($user->lang("SSL Packages"), "index.php?fuse=clients&controller=packages&view=sslpackagelist");
        $submenuItem->addViews('sslpackagelist');
        $subMenu->addItem($submenuItem);

        if ($user->hasPermission('clients_cancel_packages')) {
            $submenuItem = new NE_MenuItem($user->lang("Cancellations"), "index.php?fuse=clients&controller=packages&view=cancellations");
            $submenuItem->addViews('cancellations');
            $subMenu->addItem($submenuItem);
        }

        $menuItem->addSubmenu($subMenu);
        $this->addItem($menuItem);


        if ($user->hasPermission('affiliate_view') && CE_Lib::affiliateSystem()) {
            $menuItem = new NE_MenuItem(
                $user->lang("Affiliates"),
                "index.php?fuse=affiliates&controller=affiliate&view=viewaffiliates"
            );

            $subMenu = new NE_MenuHook($user);

            $submenuItem = new NE_MenuItem(
                $user->lang("Pending Affiliates"),
                "index.php?fuse=affiliates&controller=affiliate&view=viewaffiliates&status=0"
            );
            $submenuItem->addViews('viewaffiliates');
            $submenuItem->addActiveParam('status', '0');
            $subMenu->addItem($submenuItem);

            $submenuItem = new NE_MenuItem(
                $user->lang("All Affiliates"),
                "index.php?fuse=affiliates&controller=affiliate&view=viewaffiliates"
            );
            $submenuItem->addViews('viewaffiliates');
            $subMenu->addItem($submenuItem);

            $menuItem->addSubmenu($subMenu);
            $this->addItem($menuItem);

            $menuItem = new NE_MenuItem(
                $user->lang("Commissions"),
                "index.php?fuse=affiliates&controller=commission&view=viewcommissions"
            );
            $menuItem->setKey("third");

            $subMenu = new NE_MenuHook($user);

            $submenuItem = new NE_MenuItem(
                $user->lang("Pending Commissions"),
                "index.php?fuse=affiliates&controller=commission&view=viewcommissions&status=0"
            );
            $submenuItem->addViews('viewcommissions');
            $submenuItem->addActiveParam('status', '0');
            $subMenu->addItem($submenuItem);

            $submenuItem = new NE_MenuItem(
                $user->lang("Pending Pay Out Commission"),
                "index.php?fuse=affiliates&controller=commission&view=viewcommissions&status=4"
            );
            $submenuItem->addViews('viewcommissions');
            $submenuItem->addActiveParam('status', '4');
            $subMenu->addItem($submenuItem);

            $submenuItem = new NE_MenuItem(
                $user->lang("All Commissions"),
                "index.php?fuse=affiliates&controller=commission&view=viewcommissions"
            );
            $submenuItem->addViews('viewcommissions');
            $subMenu->addItem($submenuItem);

            $menuItem->addSubmenu($subMenu);
            $this->addItem($menuItem);
        }
    }
}
