<?php

require_once 'modules/reports/models/ReportsGateway.php';

/**
 * @package Clients
 */
class Reports_menu extends NE_MenuHook
{
    public $width = "575px;";
    public $offset = "-340px;";
    public $direction = "left";

    public function __construct($user)
    {
        if (!$user->hasPermission("reports_view")) {
            return;
        }

        // Overview
        $menuItem = new NE_MenuItem(
            $user->lang('Overview'),
            'index.php?fuse=reports&view=viewreport&controller=index&report=Overview&type=Accounts'
        );
        $menuItem->addViews('viewreport');
        $menuItem->addActiveParam('report', 'Overview');
        $menuItem->addActiveParam('type', 'Accounts');
        $this->addItem($menuItem);

        $typeArray = [];
        $fileArray = [];

        if (is_dir("plugins/reports")) {
            if ($dirhandle = opendir("plugins/reports")) {
                $reportsGateway = new ReportsGateway($user);
                while (($file = readdir($dirhandle)) !== false) {
                    if ($file !== '.svn' &&
                        $file !== '.' &&
                        $file !== '..' &&
                        $file !== basename($_SERVER['PHP_SELF']) &&
                        is_dir("plugins/reports/" . $file)
                    ) {
                        $reportsGateway->readReportForType(
                            "plugins/reports/" . $file,
                            $file,
                            $fileArray,
                            $typeArray
                        );
                    }
                }
                closedir($dirhandle);
            }
        }

        // Sort each menu section alphabetically
        sort($fileArray['Accounts']);
        sort($fileArray['Diagnostics']);
        sort($fileArray['Revenue']);
        sort($fileArray['Support']);
        sort($fileArray['Knowledgebase']);

        $report_count = 0;

        $typeArray = ["Accounts", "Diagnostics", "Revenue", "Support", "Knowledgebase"];

        $report_keys = [
            'first'  => ['accounts', 'diagnostics'],
            'second' => ['revenue'],
            'third'  => ['support', 'knowledgebase']
        ];

        foreach ($typeArray as $type) {
            $hasSubMenus = false;
            $menuItem = new NE_MenuItem($user->lang($type));

            if (in_array(strtolower($type), $report_keys['first'], true)) {
                $menuItem->setKey("first");
            } elseif (in_array(strtolower($type), $report_keys['second'], true)) {
                $menuItem->setKey("second");
            } elseif (in_array(strtolower($type), $report_keys['third'], true)) {
                $menuItem->setKey("third");
            } else {
                $menuItem->setKey("fourth");
            }

            foreach ($fileArray as $key => $name) {
                if ($key !== $type) {
                    continue;
                }

                $submenu = new NE_MenuHook($user);

                foreach ($name as $innerName) {
                    if ($innerName === 'Overview') {
                        continue;
                    }

                    $report_count++;

                    $reportName = str_replace(" ", "_", $innerName);
                    $reportNameDB = $reportName . "-" . ucfirst(str_replace(' ', '_', strtolower($type))) . ".php";
                    $reportNameFile = $type . "/" . $reportName . ".php";

                    include_once('plugins/reports/' . $reportNameFile);

                    $tReport = new $reportName();
                    $tReport->setName($reportNameDB);
                    $tReport->setUser($user);
                    $tReport->PopulateSettings();

                    if ($tReport->getPublic() == 1 || $user->hasPermission('reports_view_non_public_reports')) {
                        $hasSubMenus = true;

                        $submenuItem = new NE_MenuItem(
                            $user->lang($innerName),
                            "index.php?fuse=reports&view=viewreport&controller=index&report=" .
                            urlencode($innerName) . "&type=" . urlencode($type)
                        );
                        $submenuItem->addViews('viewreport');
                        $submenuItem->addActiveParam('report', $innerName);
                        $submenuItem->addActiveParam('type', $type);

                        $submenu->addItem($submenuItem);
                    }
                }

                $menuItem->addSubmenu($submenu);
            }

            // Parent activates when any report of this type is active
            $menuItem->addViews('viewreport');
            $menuItem->addActiveParam('type', $type);
            $menuItem->addSecondaryTag("type", $type);

            if ($hasSubMenus === true) {
                $this->addItem($menuItem);
            }
        }
    }
}
