<?php

/**
* @package Support
*/
class Support_menu extends NE_MenuHook
{
    public $width = "500px;";
    public $offset = "-378px;";
    public $direction = "left";

    public function __construct($user)
    {
        $menuItem = new NE_MenuItem(
            $user->lang('Ticket List'),
            "index.php?fuse=support&view=viewtickets&controller=ticket"
        );
        $menuItem->setHighlight('left');
        $menuItem->addClass("main-ticket-filters");
        $menuItem->addViews([
            'viewtickets',
            'viewticket',
            'viewticketevents',
            'viewticketarticles',
            'viewticketnotes'
        ]);
        $menuItem->addPermissions("support_view");

        include_once "modules/support/models/TicketSummaryGateway.php";
        $ticketSummaryGateway = new TicketSummaryGateway($user);
        $filters = $ticketSummaryGateway->GetTicketFilters();

        $subMenu = new NE_MenuHook($user);

        foreach ($filters['filters'] as $filter) {
            $submenuItem = new NE_MenuItem(
                $filter['ticketfilter_name'],
                "index.php?fuse=support&view=viewtickets&controller=ticket&searchfilter=" . $filter['ticketfilter_id']
            );
            $submenuItem->addViews('viewtickets');
            $submenuItem->addActiveParam('searchfilter', (string)$filter['ticketfilter_id']);
            $submenuItem->addAttribut("data-filter-id", $filter['ticketfilter_id']);
            $submenuItem->addAttribut("data-filter-name", $filter['ticketfilter_name']);
            $submenuItem->addClass("ticket-filter-link");

            $subMenu->addItem($submenuItem);
        }

        $menuItem->addSubmenu($subMenu);
        $this->addItem($menuItem);

        // System Filters
        $menuItem = new NE_MenuItem($user->lang("Filters"), "#");
        $menuItem->setKey("second");
        $menuItem->addViews(['lastseen', 'viewtickets']);
        $menuItem->addPermissions("support_view");

        $subMenu = new NE_MenuHook($user);

        $submenuItem = new NE_MenuItem(
            $user->lang("Add Ticket Filter"),
            "index.php?fuse=support&controller=ticketfilter&view=viewadd"
        );
        $submenuItem->addViews('viewadd');
        $subMenu->addItem($submenuItem);

        $submenuItem = new NE_MenuItem(
            $user->lang("Last Tickets Viewed"),
            "index.php?fuse=support&view=lastseen&controller=ticket&searchfilter=lastseen"
        );
        $submenuItem->addViews('lastseen');
        $submenuItem->addActiveParam('searchfilter', 'lastseen');
        $submenuItem->addAttribut("data-filter-id", "lastseen");
        $submenuItem->addAttribut("data-filter-name", $user->lang("Last Tickets Viewed"));
        $submenuItem->addClass("ticket-filter-link");
        $subMenu->addItem($submenuItem);

        $submenuItem = new NE_MenuItem(
            $user->lang("Tickets Following"),
            "index.php?fuse=support&view=viewtickets&controller=ticket&searchfilter=subscribedto"
        );
        $submenuItem->addViews('viewtickets');
        $submenuItem->addActiveParam('searchfilter', 'subscribedto');
        $submenuItem->addAttribut("data-filter-id", "subscribedto");
        $submenuItem->addAttribut("data-filter-name", $user->lang("Tickets Following"));
        $submenuItem->addClass("ticket-filter-link");
        $subMenu->addItem($submenuItem);

        $menuItem->addSubmenu($subMenu);
        $this->addItem($menuItem);

        $menuItem = new NE_MenuItem(
            $user->lang('Knowledge Base'),
            "index.php?fuse=knowledgebase&controller=articles&view=viewarticles"
        );
        $menuItem->setKey("second");
        $menuItem->addViews(['viewarticles', 'viewcomments']);
        $menuItem->addPermissions("knowledgebase_view");

        $submenu = new NE_MenuHook($user);

        $submenuItem = new NE_MenuItem(
            $user->lang("Articles"),
            "index.php?fuse=knowledgebase&controller=articles&view=viewarticles"
        );
        $submenuItem->addViews('viewarticles');
        $submenu->addItem($submenuItem);

        $submenuItem = new NE_MenuItem(
            $user->lang("Comments"),
            "index.php?fuse=knowledgebase&controller=comments&view=viewcomments"
        );
        $submenuItem->addViews('viewcomments');
        $submenuItem->addPermissions("knowledgebase_manageComments");
        $submenu->addItem($submenuItem);

        $menuItem->addSubmenu($submenu);
        $this->addItem($menuItem);

        $menuItem = new NE_MenuItem(
            $user->lang('Feedback'),
            "index.php?fuse=support&controller=tickets&view=feedback"
        );
        $menuItem->setKey("second");
        $menuItem->addViews('viewfeedback');
        $menuItem->addPermissions("support_view_feedback");

        $this->addItem($menuItem);
    }
}
