<?php

require_once 'modules/billing/models/class.gateway.plugin.php';

class PluginCoingate extends GatewayPlugin
{
    public function getVariables()
    {
        $variables = array (
            lang("Plugin Name") => array (
                "type"          => "hidden",
                "description"   => lang("How CE sees this plugin (not to be confused with the Signup Name)"),
                "value"         => lang("CoinGate")
            ),
            lang("Auth Token") => array (
                "type"          => "text",
                "description"   => lang("Enter your Authorization Token"),
                "value"         => ""
            ),

            lang("Use Sandbox Mode?") => array(
                "type"          => "yesno",
                "description"   => lang("Select YES if you wish to use the sandbox mode instead of the live environment"),
                "value"         => "0"
            ),
            lang("Signup Name") => array (
                "type"          => "text",
                "description"   => lang("Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card."),
                "value"         => "CoinGate"
            )

        );
        return $variables;
    }

    public function credit($params)
    {
        return $this->user->lang("This payment gateway does not support refunds.");
    }

    public function singlepayment($params, $test = false)
    {
        \CoinGate\Client::setAppInfo("Clientexec", CE_Lib::getAppVersion());
        $sandBox = false;
        if ($params['plugin_coingate_Use Sandbox Mode?'] == '1') {
            $sandBox = true;
        }
        $authToken = $params['plugin_coingate_Auth Token'];

        $client = new CoinGate\Client($authToken, $sandBox);

        $orderParams = [
            'order_id'          => $params['invoiceNumber'],
            'price_amount'      => number_format($params['invoiceTotal'], 8, '.', ''),
            'price_currency'    => $params['userCurrency'],
            'cancel_url'        => $params['invoiceviewURLCancel'],
            'callback_url'      => $params['clientExecURL'] . '/plugins/gateways/coingate/callback.php',
            'success_url'       => $params['invoiceviewURLSuccess'],
            'title'             => $params['companyName'],
            'description'       => $params['invoiceDescription']
        ];


        $user = new User($params['CustomerID']);

        $orderParams['shopper'] = [];
        $orderParams['shopper']['email'] = $params['userEmail'];
        $orderParams['shopper']['first_name'] = $params['userFirstName'];
        $orderParams['shopper']['last_name'] = $params['userLastName'];

        if ($user->isOrganization()) {
            $orderParams['shopper']['type'] = 'business';
            $orderParams['shopper']['company_details'] = [
                'name' => $params['userOrganization'],
                'address' => $params['userAddress'],
                'postal_code' => $params['userZipcode'],
                'city' => $params['userCity'],
                'country' => $params['userCountry'],
            ];
        } else {
            $orderParams['shopper']['type'] = 'personal';
            $orderParams['shopper']['residence_address'] = $params['userAddress'];
            $orderParams['shopper']['residence_postal_code'] = $params['userZipcode'];
            $orderParams['shopper']['residence_city'] = $params['userCity'];
            $orderParams['shopper']['residence_country'] = $params['userCountry'];
        }

        CE_Lib::log(4, 'CoinGate Params: ' . print_r($orderParams, true));
        $order = $client->order->create($orderParams);

        header('Location: ' . $order->payment_url);
        exit;
    }
}
