<?php
use Illuminate\Database\Capsule\Manager as Capsule;
require_once 'modules/admin/models/StatusAliasGateway.php';

/*
 * @package Reports
 */

class Client_Statuses extends Report {

    private $lang;
    protected $featureSet = 'accounts';
    public $hasgraph = true;

    function __construct($user = null, $customer = null)
    {
        $this->lang = lang('Client Statuses');
        parent::__construct($user, $customer);
    }

    protected function _getCustomerStatusList() {
        $statusList = array();

        foreach (StatusAliasGateway::getInstance($this->user)->getAllStatuses(ALIAS_STATUS_USER) as $status) {
            $statusList[] = array($status->statusid, $this->user->lang($status->name));
        }

        return $statusList;
    }

    protected function _getProductStatusList() {
        $statusList = array();

        foreach (StatusAliasGateway::getInstance($this->user)->getAllStatuses(ALIAS_STATUS_PACKAGE) as $status) {
            $statusList[] = array($status->statusid, $this->user->lang($status->name));
        }

        return $statusList;
    }

    protected function _getTotal($status, $totals) {
        return isset($totals[$status]) ? $totals[$status] : 0;
    }

    public function GraphData($customer_totals, $package_totals) {
        $customerStatusList = $this->_getCustomerStatusList();
        $productStatusList = $this->_getProductStatusList();

        //building graph data to pass back
        $graph_data = array(
              "xScale" => "ordinal",
              "yScale" => "linear",
              "xType" => "number",
              "type" => "bar",
              "main" => array());

        $year_data = array();
        $year_data['className'] = ".report_client_status";
        $year_data['data'] = array();

        foreach ($customerStatusList as $row) {
            if ($row[0] == -3) {
                continue;
            }

            $label = $row[1];
            $value = $this->_getTotal($row[0], $customer_totals);
            $status_data = array();
            $status_data["x"] = $label;
            $status_data["y"] = $value;
            $status_data["tip"] = "<b>".$this->user->lang("%s Clients", $this->user->lang($row[1]))."</b><br/>".$value;
            $year_data['data'][] = $status_data;
        }

        $graph_data["main"][] = $year_data;
        $year_data = array();
        $year_data['className'] = ".report_product_status";
        $year_data['data'] = array();

        foreach ($productStatusList as $row) {
            $label = $row[1];
            $value = $this->_getTotal($row[0], $package_totals);
            $status_data = array();
            $status_data["x"] = $label;
            $status_data["y"] = $value;
            $status_data["tip"] = "<b>".$this->user->lang("%s Products", $this->user->lang($row[1]))."</b><br/>".$value;
            $year_data['data'][] = $status_data;
        }

        $graph_data["main"][] = $year_data;

        return json_encode($graph_data);
    }

    public function process() {
        $this->SetDescription($this->user->lang('Your client and product\'s status.'));
        $graphdata = @$_GET['graphdata'];
        $customer_totals = array();

        $result = Capsule::table('users')
            ->selectRaw(
                'COUNT(*) as total, '
                .'status'
            )
            ->where('groupid', 1)
            ->groupBy('status')
            ->get();

        foreach ($result as $row) {
            $customer_totals[$row->status] = $row->total;
        }

        $package_totals = array();

        $result = Capsule::table('domains')
            ->selectRaw(
                'COUNT(*) as total, '
                .'status'
            )
            ->groupBy('status')
            ->get();

        foreach ($result as $row) {
            $package_totals[$row->status] = $row->total;
        }

        if ($graphdata) {
            //this supports lazy loading and dynamic loading of graphs
            $this->reportData = $this->GraphData($customer_totals, $package_totals);

            return;
        }

        $aGroup = array();
        $aLabel = array($this->user->lang('Status'), $this->user->lang('Count'));
        $statusList = $this->_getCustomerStatusList();

        foreach ($statusList as $row) {
            $label = $row[1];
            $value = $this->_getTotal($row[0], $customer_totals);
            $group = array($label, $value);
            $aGroup[] = $group;
        }

        $this->reportData[] = array(
            "group"     => $aGroup,
            "groupname" => $this->user->lang("Client Overview"),
            "label"     => $aLabel,
            "groupId"   => "",
            "isHidden"  => false
        );

        $aGroup = array();
        $statusList = $this->_getProductStatusList();

        foreach ($statusList as $row) {
            $label = $row[1];
            $value = $this->_getTotal($row[0], $package_totals);
            $group = array($label, $value);
            $aGroup[] = $group;
        }

        $this->reportData[] = array(
            "group"     => $aGroup,
            "groupname" => $this->user->lang("Package Overview"),
            "label"     => $aLabel,
            "groupId"   => "",
            "isHidden"  => false
        );
    }
}
?>