<?php
use Illuminate\Database\Capsule\Manager as Capsule;

/**
 * New_Clients Report Class
 *
 * @category Report
 * @package  ClientExec
 * @license  ClientExec License
 * @link     http://www.clientexec.com
 */

class New_Clients extends Report
{
    private $lang;

    protected $featureSet = 'accounts';
    public $hasgraph = true;
    private $currentYear = null;
    private $yearCount = 1;

    function __construct($user = null, $customer = null)
    {
        $this->lang = lang('New Clients');
        parent::__construct($user, $customer);
    }

    /**
     * Report Process Method
     *
     * @return null - direct output
     */
    function process()
    {
        $this->options = array(
            "label"     => $this->user->lang("Date Range"),
            "values"    => array(
                $this->user->lang("View this week")  => 0,
                //$this->user->lang("View this month") => 1,
                $this->user->lang("View this year")  => 2
            ),
            "defaultid" => 0
        );

        // Set the report information
        $this->SetDescription($this->user->lang('Displays the total number of new signups for a given year broken down by month.'));

        if (!isset($_GET['option_id'])) {
            if (isset($_GET['indashboard'])) {
                $option_id = 0;
            } else {
                $option_id = 2;
            }
        } else {
            $option_id = filter_input(INPUT_GET, 'option_id', FILTER_SANITIZE_NUMBER_INT);
        }

        if (!isset($_GET['passedyear'])) {
            $currentYear = date("Y");
        } else {
            $currentYear = filter_input(INPUT_GET, 'passedyear', FILTER_SANITIZE_NUMBER_INT);
        }

        $status = INVOICE_STATUS_PAID;

        $result = Capsule::table('users as u')
            ->selectRaw('MAX(YEAR(u.dateActivated)) as yearactivated')
            ->whereIn('u.groupid', function ($subQuery) {
                $subQuery->select('g.id')
                    ->from('groups as g')
                    ->where('g.isadmin', 0);
            })
            ->whereIn('u.id', function ($subQuery) use ($status) {
                $subQuery->selectRaw('DISTINCT i.customerid')
                    ->from('invoice as i')
                    ->where('i.status', $status);
            })
            ->get();

        foreach ($result as $row) {
            $maxYear = $row->yearactivated;
        }

        $aYears = $this->returnRows($option_id, $currentYear);
        $graphdata = @$_GET['graphdata'];

        if ($graphdata) {
            //this supports lazy loading and dynamic loading of graphs
            $this->reportData = $this->GraphData($aYears, $option_id);
            return;
        }

        //Display Report
        echo "<script type='text/javascript'>";
        echo "function ShowYears(obj) {";
        echo "    var strYear = obj.value;";

        //Loop the number of years
        for ($x = 0; $x < $this->yearCount; $x++) {
            $xYear = $maxYear - $x;
            $yearsback = $x + 1;
            echo "    if (document.getElementById('id-$xYear') != null) {";
            echo "        document.getElementById('id-$xYear').style.display = 'none';";
            echo "    }";
            echo "    if (document.getElementById('id-$xYear-totals') != null) {";
            echo "        document.getElementById('id-$xYear-totals').style.display = 'none';";
            echo "    }";
            echo "    if (document.getElementById('id-Last$yearsback') != null) {";
            echo "        document.getElementById('id-Last$yearsback').style.display = 'none';";
            echo "    }";
            echo "    if (document.getElementById('id-Last$yearsback-totals') != null) {";
            echo "        document.getElementById('id-Last$yearsback-totals').style.display = 'none';";
            echo "    }";
        }

        echo "        if (document.getElementById('id-' + obj.value) != null) {";
        echo "            document.getElementById('id-' + obj.value).style.display = '';";
        echo "        }";
        echo "        if (document.getElementById('id-' + obj.value + '-totals') != null) {";
        echo "            document.getElementById('id-' + obj.value + '-totals').style.display = '';";
        echo "        }";
        echo "    clientexec.populate_report('New_Clients-Accounts', '#myChartCanvas', {passedyear:obj.value});\n";
        echo "}";
        echo "</script>";

        echo "<div style='margin-left:20px;'>";
        echo "    <form id='reportdropdown' method='GET'>";
        echo "        <input type='hidden' name='fuse' value='reports' />";
        echo "        <input type='hidden' name='report' value='New Clients' />";
        echo "        <input type='hidden' name='view' value='viewreport' />";
        echo "        <input type='hidden' name='type' value='Accounts' />";

        echo "        ".$this->user->lang('Select Year Range')."<br/>";
        echo "        <select id='passedyear' class='normalSelect2 w-10' name='passedyear' onChange='ShowYears(this);'>";

        //Loop the number of years
        for ($x = 0; $x < $this->yearCount; $x++) {
            $xYear = $maxYear - $x;

            if ($currentYear == $xYear) {
                echo "            <option value='".$xYear."' SELECTED>".$xYear."</option>";
            } else {
                echo "            <option value='".$xYear."'>".$xYear."</option>";
            }
        }

        //Create based on number of years of data available
        for ($x = 1; $x < $this->yearCount; $x++) {
            $value = $x + 1;

            if ($currentYear == "Last$value") {
                echo "            <option value='Last$value' SELECTED>Last $value Years&nbsp;&nbsp;&nbsp;</option>";
            } else {
                echo "            <option value='Last$value'>Last $value Years&nbsp;&nbsp;&nbsp;</option>";
            }
        }

        echo "        </select>";
        echo "    </form>";
        echo "</div>";
    }

    /**
     * Function to generate the graph data
     *
     * @return null - direct output
     */
    function GraphData($aYears, $option_id)
    {
        if ($option_id == 0) {
            //we only care about this week
            $currentYear = date('Y');
            $number_of_years = 7; // using number of years for days
            $xScale = "ordinal";
            $yScale = "linear";
            $xType = "daysofweek";
            $type = "bar";
        } else {
            $xScale = "time";
            $xType = "";
            $yScale = "linear";
            $type = "line-dotted";

            if (!isset($_REQUEST['passedyear'])) {
                if (isset($_GET['indashboard'])) {
                    $currentYear = "Last2";
                } else {
                    $currentYear = date("Y");
                }
            } else {
                $currentYear = $_REQUEST['passedyear'];
            }

            $number_of_years = 0;

            if (mb_substr($currentYear, 0, 4) == "Last") {
                $number_of_years = mb_substr($currentYear, 4);
            }
        }

        $yearCount = 0;
        $ydata = array();

        //building graph data to pass back
        $graph_data = array(
            "xScale" => $xScale,
            "yScale" => $yScale,
            "xType"  => $xType,
            "type"   => $type,
            "main"   => array()
        );

        foreach ($aYears as $key => $aYear) {
            if ($number_of_years > 0 || $currentYear == $key) {
                $year_data = array();
                $year_data['className'] = ".report_".$key;
                $year_data['data'] = array();

                foreach ($aYear as $months) {
                    if (!is_array($months)) {
                        continue;
                    }

                    foreach ($months as $year => $monthtotal) {
                        $month_data = array();

                        if ($monthtotal[1] == "") {
                            $monthtotal[1] = "0";
                        }

                        if ($option_id == 0) {
                            $month_data["x"] = $monthtotal[0];
                            $month_data["y"] = $monthtotal[1];
                            $month_data["tip"] = "<strong>".$this->user->lang($monthtotal[0])."</strong><br/>".$this->user->lang("New clients").": ".$monthtotal[1];
                        } else {
                            $month_data["x"] = $year;
                            $month_data["y"] = $monthtotal[1];
                            $month_data["tip"] = "<strong>".$this->user->lang($monthtotal[0]).", ".$key."</strong><br/>".$this->user->lang("New clients").": ".$monthtotal[1];
                        }

                        $year_data['data'][] = $month_data;
                    }

                    // if there's no data, fill with emptiness for the graph to at least show the axis (this is for the dashboard)
                    if (!$year_data['data']) {
                        $year_data['data'] = array(
                            array(
                                'x'   => date("$year-01-01"),
                                'y'   => 0,
                                'tip' => $this->user->lang('No Data')
                            )
                        );
                    }

                    $graph_data["main"][] = $year_data;
                }

                $number_of_years--;
            }
        }

        // if there's no data, fill with emptiness for the graph to at least show the axis (this is for the reports module)
        if (!$graph_data['main']) {
            $graph_data['main'] = array(
                array(
                    'className' => '.report_'.date('Y'),
                    'data'      => array(
                        array(
                            'x'   => date('Y-01-01'),
                            'y'   => 0,
                            'tip' => $this->user->lang('No Data')
                        )
                    )
                )
            );
        }

        return json_encode($graph_data);
    }

    private function ord($a)
    {
        // return English ordinal number
        return $a.substr(date('jS', mktime(0, 0, 0, 1, ($a % 10 == 0? 9 : ($a % 100 > 20? $a % 10 : $a % 100)), 2000)), -2);
    }

    private function retunRowsForWeek()
    {
        $aYears = array();
        $status = INVOICE_STATUS_PAID;
        $weekCount = 0;
        $dayGroup = array();

        $result = Capsule::table('users as u')
            ->selectRaw(
                'COUNT(u.id) as count, '
                .'DATE_FORMAT(u.dateActivated, "%W") as day, '
                .'DATE_FORMAT(u.dateActivated, "%w") as day_num, '
                .'DATE_FORMAT(u.dateActivated, "%Y-%m-%d") as dateActivated, '
                .'DATE_FORMAT(u.dateActivated, "%d") as dayActivated'
            )
            ->whereIn('u.groupid', function ($subQuery) {
                $subQuery->select('g.id')
                    ->from('groups as g')
                    ->where('g.isadmin', 0);
            })
            ->whereIn('u.id', function ($subQuery) use ($status) {
                $subQuery->selectRaw('DISTINCT i.customerid')
                    ->from('invoice as i')
                    ->where('i.status', $status);
            })
            ->whereRaw('DATE_ADD(u.dateActivated, INTERVAL 7 DAY) > NOW()')
            ->groupBy('dateActivated')
            ->orderBy('u.dateActivated', 'ASC')
            ->get();

        foreach ($result as $row) {
            $weekCount += $row->count;
            $group[] = array(
                "<b>".$row->day."</b> (".$row->dateActivated.")",
                $row->count
            );

            $aYears[0][0][$row->day_num] = array(
                $row->dateActivated,
                $row->count,
                $row->day_num
            );
        }

        //let's fill in the gaps
        $dowMap = array(
            'Sunday',
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday'
        );

        for ($x = 0; $x <= 6; $x++) {
            if (!isset($aYears[0][0][$x])) {
                if (date('%w', time()) == $x) {
                    $dateActivated = date("Y-m-d", time());
                } else {
                    $dateActivated = date("Y-m-d", strtotime('last '.$dowMap[$x]));
                }

                $aYears[0][0][$x] = array(
                    $dateActivated,
                    0,
                    $x
                );
            }
        }

        //CE_Lib::debug($aYears[0][0]);

        $group[] = array(
            "",
            $this->user->lang('Total Count')
        );

        $group[] = array(
            "",
            $weekCount
        );

        $this->reportData[] = array(
            "group"     => $group,
            "groupname" => $this->user->lang("New Clients This Week"),
            "label"     => array(
                $this->user->lang('Day'),
                $this->user->lang('Count')
            ),
            "groupId"   => 'week',
            "isHidden"  => false
        );

        return $aYears;
    }

    private function createClearYear($tYear)
    {
        $aYear = array();

        $aYear[$tYear.'-01-1'] = array(
            date("F", mktime(0, 0, 0, 1 + 1, 0, 0)),
            0
        );
        $aYear[$tYear.'-02-1'] = array(
            date("F", mktime(0, 0, 0, 2 + 1, 0, 0)),
            0
        );
        $aYear[$tYear.'-03-1'] = array(
            date("F", mktime(0, 0, 0, 3 + 1, 0, 0)),
            0
        );
        $aYear[$tYear.'-04-1'] = array(
            date("F", mktime(0, 0, 0, 4 + 1, 0, 0)),
            0
        );
        $aYear[$tYear.'-05-1'] = array(
            date("F", mktime(0, 0, 0, 5 + 1, 0, 0)),
            0
        );
        $aYear[$tYear.'-06-1'] = array(
            date("F", mktime(0, 0, 0, 6 + 1, 0, 0)),
            0
        );
        $aYear[$tYear.'-07-1'] = array(
            date("F", mktime(0, 0, 0, 7 + 1, 0, 0)),
            0
        );
        $aYear[$tYear.'-08-1'] = array(
            date("F", mktime(0, 0, 0, 8 + 1, 0, 0)),
            0
        );
        $aYear[$tYear.'-09-1'] = array(
            date("F", mktime(0, 0, 0, 9 + 1, 0, 0)),
            0
        );
        $aYear[$tYear.'-10-1'] = array(
            date("F", mktime(0, 0, 0, 10 + 1, 0, 0)),
            0
        );
        $aYear[$tYear.'-11-1'] = array(
            date("F", mktime(0, 0, 0, 11 + 1, 0, 0)),
            0
        );
        $aYear[$tYear.'-12-1'] = array(
            date("F", mktime(0, 0, 0, 12 + 1, 0, 0)),
            0
        );

        return $aYear;
    }

    private function returnRows($option_id, $currentYear)
    {
        if ($option_id == 0) {
            $aYears = $this->retunRowsForWeek();
            return $aYears;
        }

        $aYears = array();
        $status = INVOICE_STATUS_PAID;
        $firstTime = true;
        $sumCount = 0;
        $sumAffCount = 0;
        $aYear = array();
        $previousYear = 0;
        $newYear = 0;
        $maxYear = date("Y");
        $lastMonthCount = 0;

        $result = Capsule::table('users as u')
            ->selectRaw(
                'COUNT(u.id) as usercount, '
                .'MONTH(u.dateActivated) as monthactivated, '
                .'YEAR(u.dateActivated) as yearactivated, '
                .'DATE_FORMAT(u.dateActivated, "%Y-%m-1") as dateActivated'
            )
            ->whereIn('u.groupid', function ($subQuery) {
                $subQuery->select('g.id')
                    ->from('groups as g')
                    ->where('g.isadmin', 0);
            })
            ->whereIn('u.id', function ($subQuery) use ($status) {
                $subQuery->selectRaw('DISTINCT i.customerid')
                    ->from('invoice as i')
                    ->where('i.status', $status);
            })
            ->groupBy('yearactivated', 'monthactivated')
            ->orderBy('yearactivated', 'DESC')
            ->get();

        foreach ($result as $row) {
            $tMonth = date("F", mktime(0, 0, 0, $row->monthactivated + 1, 0, 0));
            $month_date = $row->dateActivated;
            $tYear = $row->yearactivated;

            if ($firstTime) {
                $maxYear = $tYear;

                //Lets create the full year, before adding values, to avoid missing months and also making sure to have them in the right order
                $aYear = $this->createClearYear($tYear);
                $previousYear = (int)$tYear - 1;
                $newYear = $tYear;
                $firstTime = false;
            }

            if ($newYear != $tYear) {
                $aYears[$newYear]["array"] = $aYear;
                $aYears[$newYear]["sumCount"] = $sumCount;
                $newYear = $tYear;
                $sumCount = 0;

                while ($tYear < $previousYear) {
                    //Lets create the full year, before adding values, to avoid missing months and also making sure to have them in the right order
                    $aYear = $this->createClearYear($previousYear);

                    $aYears[$previousYear]["array"] = $aYear;
                    $aYears[$previousYear]["sumCount"] = $sumCount;
                    $previousYear--;
                }

                //Lets create the full year, before adding values, to avoid missing months and also making sure to have them in the right order
                $aYear = $this->createClearYear($tYear);
                $previousYear--;
            }


            $tCount = $row->usercount;
            $sumCount += $tCount;

            $aYear[$month_date] = array(
                $tMonth,
                $tCount
            );

            $lastMonthCount = $row->usercount;
        }

        $aYears[$newYear]["array"] = $aYear;
        $aYears[$newYear]["sumCount"] = $sumCount;
        $this->yearCount = count($aYears);

        $line = array(
            'Year' => '',
            'January' => '-',
            'February' => '-',
            'March' => '-',
            'April' => '-',
            'May' => '-',
            'June' => '-',
            'July' => '-',
            'August' => '-',
            'September' => '-',
            'October' => '-',
            'November' => '-',
            'December' => '-',
            'Total' => ''
        );

        $labels = array_keys($line);

        foreach ($labels as $labelKey => $labelValue) {
            $labels[$labelKey] = $this->user->lang($labelValue);
        }

        $lastXYears = array();

        foreach ($aYears as $key => $aYear) {
            $grouphidden = true;
            $groupid = "id-".$key;

            if ($currentYear == $key) {
                $grouphidden = false;
            } else {
                if (mb_substr($currentYear, 0, 4) == "Last") {
                    $tYears = mb_substr($currentYear, 4);

                    if ($key > date("Y") - $tYears) {
                        $grouphidden = false;
                    }
                }
            }

            $groupLine = $line;
            $groupLine['Year'] = $key;
            $groupLine['Total'] = $aYear["sumCount"];

            foreach ($aYear["array"] as $month) {
                $groupLine[$month[0]] = $month[1];
            }

            $groupLineFinal = $groupLine;
            $groupLineFinal['Total'] = '<b>'.$groupLineFinal['Total'].'</b>';
            $aGroup = array();
            $aGroup[] = array_values($groupLineFinal);
            $xYears = $maxYear - $key + 1;

            //Create based on number of years of data available
            for ($x = 1; $x < $this->yearCount; $x++) {
                $value = $x + 1;

                $lastXYears[$value]['groupid'] = "id-Last".$value;
                $lastXYears[$value]['groupname'] = $this->user->lang("New Clients In The Last %s Years", $value);

                if ($currentYear == "Last$value") {
                    $lastXYears[$value]['grouphidden'] = false;
                } else {
                    $lastXYears[$value]['grouphidden'] = true;
                }

                if ($xYears <=  $value) {
                    $groupLineFinal = $groupLine;
                    $groupLineFinal['Total'] = '<b>'.$groupLineFinal['Total'].'</b>';
                    $lastXYears[$value]['group'][] = array_values($groupLineFinal);

                    if (!isset($lastXYears[$value]['totalline'])) {
                        $lastXYears[$value]['totalline'] = $line;
                        $lastXYears[$value]['totalline']['Year'] = $this->user->lang("Last %s Years", $value);
                    }

                    foreach ($lastXYears[$value]['totalline'] as $lineKey => $lineValue) {
                        if ($lineKey == 'Year') {
                            continue;
                        }

                        if ($lineValue == '-') {
                            $lastXYears[$value]['totalline'][$lineKey] = $groupLine[$lineKey];
                        } elseif ($groupLine[$lineKey] != '-') {
                            $lastXYears[$value]['totalline'][$lineKey] = (int)$lastXYears[$value]['totalline'][$lineKey] + (int)$groupLine[$lineKey];
                        }
                    }
                }
            }

            $this->reportData[] = array(
                "group"     => $aGroup,
                "groupname" => $this->user->lang("New Clients In %s", $key),
                "label"     => $labels,
                "groupId"   => $groupid,
                "isHidden"  => $grouphidden
            );
        }

        //Create based on number of years of data available
        for ($x = 1; $x < $this->yearCount; $x++) {
            $value = $x + 1;

            $groupLineFinal = $lastXYears[$value]['totalline'];

            foreach ($groupLineFinal as $lineKey => $lineValue) {
                $groupLineFinal[$lineKey] = '<b>'.$lineValue.'</b>';
            }

            $lastXYears[$value]['group'][] = array_values($groupLineFinal);
            $lastXYears[$value]['groupid'] = "id-Last".$value;
            $this->reportData[] = array(
                "group"     => $lastXYears[$value]['group'],
                "groupname" => $lastXYears[$value]['groupname'],
                "label"     => $labels,
                "groupId"   => $lastXYears[$value]['groupid'],
                "isHidden"  => $lastXYears[$value]['grouphidden']
            );
        }

        return $aYears;
    }

    private function ReturnMonthsArray($aMonth, $currentYear, $valIndex = 1)
    {
        //Get all months values
        //Loop through 12 months using long date description and determine
        //if aMonth contains that month.  If not return 0.0

        $aReturn = array();

        for ($x = 1; $x <= 12; $x++) {
            $tstrMonth = date("F", mktime(0, 0, 0, $x + 1, 0, 0));
            $valIndex = 1;

            if (!isset($aMonth[$tstrMonth])) {
                $aReturn[] = "";
            } elseif ($aMonth[$tstrMonth][$valIndex] == "na") {
                $aReturn[] = "";
            } else {
                $tempY = (int) $aMonth[$tstrMonth][$valIndex];
                $aReturn[] = $tempY;
            }

            if (($currentYear == date("Y")) && (date("F") == $tstrMonth)) {
                return $aReturn;
            }
        }

        return $aReturn;
    }
}
