<?php
/**
 * DnsZone
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.13.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Model;

use \ArrayAccess;
use \OpenAPI\Client\ObjectSerializer;

/**
 * DnsZone Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class DnsZone implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'DnsZone';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'origin' => 'string',
        'soa' => '\OpenAPI\Client\Model\DnsSoa',
        'records' => '\OpenAPI\Client\Model\DnsRecord[]',
        'dnssec_ds_records' => 'string',
        'dnssec_dnskey_records' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'origin' => null,
        'soa' => null,
        'records' => null,
        'dnssec_ds_records' => null,
        'dnssec_dnskey_records' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'origin' => false,
        'soa' => false,
        'records' => false,
        'dnssec_ds_records' => false,
        'dnssec_dnskey_records' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'origin' => 'origin',
        'soa' => 'soa',
        'records' => 'records',
        'dnssec_ds_records' => 'dnssecDsRecords',
        'dnssec_dnskey_records' => 'dnssecDnskeyRecords'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'origin' => 'setOrigin',
        'soa' => 'setSoa',
        'records' => 'setRecords',
        'dnssec_ds_records' => 'setDnssecDsRecords',
        'dnssec_dnskey_records' => 'setDnssecDnskeyRecords'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'origin' => 'getOrigin',
        'soa' => 'getSoa',
        'records' => 'getRecords',
        'dnssec_ds_records' => 'getDnssecDsRecords',
        'dnssec_dnskey_records' => 'getDnssecDnskeyRecords'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('origin', $data ?? [], null);
        $this->setIfExists('soa', $data ?? [], null);
        $this->setIfExists('records', $data ?? [], null);
        $this->setIfExists('dnssec_ds_records', $data ?? [], null);
        $this->setIfExists('dnssec_dnskey_records', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['origin'] === null) {
            $invalidProperties[] = "'origin' can't be null";
        }
        if ($this->container['soa'] === null) {
            $invalidProperties[] = "'soa' can't be null";
        }
        if ($this->container['records'] === null) {
            $invalidProperties[] = "'records' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets origin
     *
     * @return string
     */
    public function getOrigin()
    {
        return $this->container['origin'];
    }

    /**
     * Sets origin
     *
     * @param string $origin origin
     *
     * @return self
     */
    public function setOrigin($origin)
    {
        if (is_null($origin)) {
            throw new \InvalidArgumentException('non-nullable origin cannot be null');
        }
        $this->container['origin'] = $origin;

        return $this;
    }

    /**
     * Gets soa
     *
     * @return \OpenAPI\Client\Model\DnsSoa
     */
    public function getSoa()
    {
        return $this->container['soa'];
    }

    /**
     * Sets soa
     *
     * @param \OpenAPI\Client\Model\DnsSoa $soa soa
     *
     * @return self
     */
    public function setSoa($soa)
    {
        if (is_null($soa)) {
            throw new \InvalidArgumentException('non-nullable soa cannot be null');
        }
        $this->container['soa'] = $soa;

        return $this;
    }

    /**
     * Gets records
     *
     * @return \OpenAPI\Client\Model\DnsRecord[]
     */
    public function getRecords()
    {
        return $this->container['records'];
    }

    /**
     * Sets records
     *
     * @param \OpenAPI\Client\Model\DnsRecord[] $records records
     *
     * @return self
     */
    public function setRecords($records)
    {
        if (is_null($records)) {
            throw new \InvalidArgumentException('non-nullable records cannot be null');
        }
        $this->container['records'] = $records;

        return $this;
    }

    /**
     * Gets dnssec_ds_records
     *
     * @return string|null
     */
    public function getDnssecDsRecords()
    {
        return $this->container['dnssec_ds_records'];
    }

    /**
     * Sets dnssec_ds_records
     *
     * @param string|null $dnssec_ds_records dnssec_ds_records
     *
     * @return self
     */
    public function setDnssecDsRecords($dnssec_ds_records)
    {
        if (is_null($dnssec_ds_records)) {
            throw new \InvalidArgumentException('non-nullable dnssec_ds_records cannot be null');
        }
        $this->container['dnssec_ds_records'] = $dnssec_ds_records;

        return $this;
    }

    /**
     * Gets dnssec_dnskey_records
     *
     * @return string|null
     */
    public function getDnssecDnskeyRecords()
    {
        return $this->container['dnssec_dnskey_records'];
    }

    /**
     * Sets dnssec_dnskey_records
     *
     * @param string|null $dnssec_dnskey_records dnssec_dnskey_records
     *
     * @return self
     */
    public function setDnssecDnskeyRecords($dnssec_dnskey_records)
    {
        if (is_null($dnssec_dnskey_records)) {
            throw new \InvalidArgumentException('non-nullable dnssec_dnskey_records cannot be null');
        }
        $this->container['dnssec_dnskey_records'] = $dnssec_dnskey_records;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


