<?php
/**
 * UpdateImportServerSettings
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.13.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Model;

use \ArrayAccess;
use \OpenAPI\Client\ObjectSerializer;

/**
 * UpdateImportServerSettings Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class UpdateImportServerSettings implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'UpdateImportServerSettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'hostname' => 'string',
        'friendly_name' => 'string',
        'ssh_user' => 'string',
        'ssh_public_key' => 'string',
        'ssh_private_key' => 'string',
        'auth_kind' => '\OpenAPI\Client\Model\ServerMigrationSettingsAuthType',
        'auth_user' => 'string',
        'ssh_port' => 'float',
        'api_port' => 'float',
        'allow_partial_sync' => 'bool',
        'as_user_root' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'hostname' => null,
        'friendly_name' => null,
        'ssh_user' => null,
        'ssh_public_key' => null,
        'ssh_private_key' => null,
        'auth_kind' => null,
        'auth_user' => null,
        'ssh_port' => null,
        'api_port' => null,
        'allow_partial_sync' => null,
        'as_user_root' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'hostname' => false,
        'friendly_name' => false,
        'ssh_user' => false,
        'ssh_public_key' => false,
        'ssh_private_key' => false,
        'auth_kind' => false,
        'auth_user' => false,
        'ssh_port' => false,
        'api_port' => false,
        'allow_partial_sync' => false,
        'as_user_root' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'hostname' => 'hostname',
        'friendly_name' => 'friendlyName',
        'ssh_user' => 'sshUser',
        'ssh_public_key' => 'sshPublicKey',
        'ssh_private_key' => 'sshPrivateKey',
        'auth_kind' => 'authKind',
        'auth_user' => 'authUser',
        'ssh_port' => 'sshPort',
        'api_port' => 'apiPort',
        'allow_partial_sync' => 'allowPartialSync',
        'as_user_root' => 'asUserRoot'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'hostname' => 'setHostname',
        'friendly_name' => 'setFriendlyName',
        'ssh_user' => 'setSshUser',
        'ssh_public_key' => 'setSshPublicKey',
        'ssh_private_key' => 'setSshPrivateKey',
        'auth_kind' => 'setAuthKind',
        'auth_user' => 'setAuthUser',
        'ssh_port' => 'setSshPort',
        'api_port' => 'setApiPort',
        'allow_partial_sync' => 'setAllowPartialSync',
        'as_user_root' => 'setAsUserRoot'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'hostname' => 'getHostname',
        'friendly_name' => 'getFriendlyName',
        'ssh_user' => 'getSshUser',
        'ssh_public_key' => 'getSshPublicKey',
        'ssh_private_key' => 'getSshPrivateKey',
        'auth_kind' => 'getAuthKind',
        'auth_user' => 'getAuthUser',
        'ssh_port' => 'getSshPort',
        'api_port' => 'getApiPort',
        'allow_partial_sync' => 'getAllowPartialSync',
        'as_user_root' => 'getAsUserRoot'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('hostname', $data ?? [], null);
        $this->setIfExists('friendly_name', $data ?? [], null);
        $this->setIfExists('ssh_user', $data ?? [], null);
        $this->setIfExists('ssh_public_key', $data ?? [], null);
        $this->setIfExists('ssh_private_key', $data ?? [], null);
        $this->setIfExists('auth_kind', $data ?? [], null);
        $this->setIfExists('auth_user', $data ?? [], null);
        $this->setIfExists('ssh_port', $data ?? [], null);
        $this->setIfExists('api_port', $data ?? [], null);
        $this->setIfExists('allow_partial_sync', $data ?? [], null);
        $this->setIfExists('as_user_root', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets hostname
     *
     * @return string|null
     */
    public function getHostname()
    {
        return $this->container['hostname'];
    }

    /**
     * Sets hostname
     *
     * @param string|null $hostname hostname
     *
     * @return self
     */
    public function setHostname($hostname)
    {
        if (is_null($hostname)) {
            throw new \InvalidArgumentException('non-nullable hostname cannot be null');
        }
        $this->container['hostname'] = $hostname;

        return $this;
    }

    /**
     * Gets friendly_name
     *
     * @return string|null
     */
    public function getFriendlyName()
    {
        return $this->container['friendly_name'];
    }

    /**
     * Sets friendly_name
     *
     * @param string|null $friendly_name friendly_name
     *
     * @return self
     */
    public function setFriendlyName($friendly_name)
    {
        if (is_null($friendly_name)) {
            throw new \InvalidArgumentException('non-nullable friendly_name cannot be null');
        }
        $this->container['friendly_name'] = $friendly_name;

        return $this;
    }

    /**
     * Gets ssh_user
     *
     * @return string|null
     */
    public function getSshUser()
    {
        return $this->container['ssh_user'];
    }

    /**
     * Sets ssh_user
     *
     * @param string|null $ssh_user ssh_user
     *
     * @return self
     */
    public function setSshUser($ssh_user)
    {
        if (is_null($ssh_user)) {
            throw new \InvalidArgumentException('non-nullable ssh_user cannot be null');
        }
        $this->container['ssh_user'] = $ssh_user;

        return $this;
    }

    /**
     * Gets ssh_public_key
     *
     * @return string|null
     */
    public function getSshPublicKey()
    {
        return $this->container['ssh_public_key'];
    }

    /**
     * Sets ssh_public_key
     *
     * @param string|null $ssh_public_key ssh_public_key
     *
     * @return self
     */
    public function setSshPublicKey($ssh_public_key)
    {
        if (is_null($ssh_public_key)) {
            throw new \InvalidArgumentException('non-nullable ssh_public_key cannot be null');
        }
        $this->container['ssh_public_key'] = $ssh_public_key;

        return $this;
    }

    /**
     * Gets ssh_private_key
     *
     * @return string|null
     */
    public function getSshPrivateKey()
    {
        return $this->container['ssh_private_key'];
    }

    /**
     * Sets ssh_private_key
     *
     * @param string|null $ssh_private_key ssh_private_key
     *
     * @return self
     */
    public function setSshPrivateKey($ssh_private_key)
    {
        if (is_null($ssh_private_key)) {
            throw new \InvalidArgumentException('non-nullable ssh_private_key cannot be null');
        }
        $this->container['ssh_private_key'] = $ssh_private_key;

        return $this;
    }

    /**
     * Gets auth_kind
     *
     * @return \OpenAPI\Client\Model\ServerMigrationSettingsAuthType|null
     */
    public function getAuthKind()
    {
        return $this->container['auth_kind'];
    }

    /**
     * Sets auth_kind
     *
     * @param \OpenAPI\Client\Model\ServerMigrationSettingsAuthType|null $auth_kind auth_kind
     *
     * @return self
     */
    public function setAuthKind($auth_kind)
    {
        if (is_null($auth_kind)) {
            throw new \InvalidArgumentException('non-nullable auth_kind cannot be null');
        }
        $this->container['auth_kind'] = $auth_kind;

        return $this;
    }

    /**
     * Gets auth_user
     *
     * @return string|null
     */
    public function getAuthUser()
    {
        return $this->container['auth_user'];
    }

    /**
     * Sets auth_user
     *
     * @param string|null $auth_user auth_user
     *
     * @return self
     */
    public function setAuthUser($auth_user)
    {
        if (is_null($auth_user)) {
            throw new \InvalidArgumentException('non-nullable auth_user cannot be null');
        }
        $this->container['auth_user'] = $auth_user;

        return $this;
    }

    /**
     * Gets ssh_port
     *
     * @return float|null
     */
    public function getSshPort()
    {
        return $this->container['ssh_port'];
    }

    /**
     * Sets ssh_port
     *
     * @param float|null $ssh_port ssh_port
     *
     * @return self
     */
    public function setSshPort($ssh_port)
    {
        if (is_null($ssh_port)) {
            throw new \InvalidArgumentException('non-nullable ssh_port cannot be null');
        }
        $this->container['ssh_port'] = $ssh_port;

        return $this;
    }

    /**
     * Gets api_port
     *
     * @return float|null
     */
    public function getApiPort()
    {
        return $this->container['api_port'];
    }

    /**
     * Sets api_port
     *
     * @param float|null $api_port api_port
     *
     * @return self
     */
    public function setApiPort($api_port)
    {
        if (is_null($api_port)) {
            throw new \InvalidArgumentException('non-nullable api_port cannot be null');
        }
        $this->container['api_port'] = $api_port;

        return $this;
    }

    /**
     * Gets allow_partial_sync
     *
     * @return bool|null
     */
    public function getAllowPartialSync()
    {
        return $this->container['allow_partial_sync'];
    }

    /**
     * Sets allow_partial_sync
     *
     * @param bool|null $allow_partial_sync allow_partial_sync
     *
     * @return self
     */
    public function setAllowPartialSync($allow_partial_sync)
    {
        if (is_null($allow_partial_sync)) {
            throw new \InvalidArgumentException('non-nullable allow_partial_sync cannot be null');
        }
        $this->container['allow_partial_sync'] = $allow_partial_sync;

        return $this;
    }

    /**
     * Gets as_user_root
     *
     * @return bool|null
     */
    public function getAsUserRoot()
    {
        return $this->container['as_user_root'];
    }

    /**
     * Sets as_user_root
     *
     * @param bool|null $as_user_root as_user_root
     *
     * @return self
     */
    public function setAsUserRoot($as_user_root)
    {
        if (is_null($as_user_root)) {
            throw new \InvalidArgumentException('non-nullable as_user_root cannot be null');
        }
        $this->container['as_user_root'] = $as_user_root;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


