<?php
/**
 * Website
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.13.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Model;

use \ArrayAccess;
use \OpenAPI\Client\ObjectSerializer;

/**
 * Website Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Website implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Website';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'domain' => '\OpenAPI\Client\Model\WebsiteDomain',
        'aliases' => '\OpenAPI\Client\Model\WebsiteDomain[]',
        'subdomains' => 'mixed[]',
        'subscription_id' => 'float',
        'plan_id' => 'float',
        'plan' => 'string',
        'status' => '\OpenAPI\Client\Model\WebsiteStatus',
        'suspended_by' => 'string',
        'color_code' => 'string',
        'tags' => '\OpenAPI\Client\Model\Tag[]',
        'size' => 'int',
        'org_id' => 'string',
        'org' => 'string',
        'kind' => '\OpenAPI\Client\Model\WebsiteKind',
        'pending_backup' => '\OpenAPI\Client\Model\BackupAction',
        'parent' => 'string',
        'parent_id' => 'string',
        'app_server_id' => 'string',
        'backup_server_id' => 'string',
        'db_server_id' => 'string',
        'email_server_id' => 'string',
        'unix_user' => 'string',
        'site_access_members' => '\OpenAPI\Client\Model\SiteAccessMember[]',
        'server_ips' => '\OpenAPI\Client\Model\ServerIp[]',
        'backup_server_ips' => '\OpenAPI\Client\Model\ServerIp[]',
        'db_server_ips' => '\OpenAPI\Client\Model\ServerIp[]',
        'email_server_ips' => '\OpenAPI\Client\Model\ServerIp[]',
        'filerd_address' => 'string',
        'php_version' => '\OpenAPI\Client\Model\PhpVersion',
        'created_at' => 'string',
        'app_server_name' => 'string',
        'db_server_name' => 'string',
        'email_server_name' => 'string',
        'backup_server_name' => 'string',
        'can_use' => '\OpenAPI\Client\Model\CanUse',
        'app_server_ipv6' => 'string',
        'db_server_ipv6' => 'string',
        'email_server_ipv6' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'domain' => null,
        'aliases' => null,
        'subdomains' => null,
        'subscription_id' => null,
        'plan_id' => null,
        'plan' => null,
        'status' => null,
        'suspended_by' => 'uuid',
        'color_code' => null,
        'tags' => null,
        'size' => null,
        'org_id' => 'uuid',
        'org' => null,
        'kind' => null,
        'pending_backup' => null,
        'parent' => null,
        'parent_id' => 'uuid',
        'app_server_id' => 'uuid',
        'backup_server_id' => 'uuid',
        'db_server_id' => 'uuid',
        'email_server_id' => 'uuid',
        'unix_user' => null,
        'site_access_members' => null,
        'server_ips' => null,
        'backup_server_ips' => null,
        'db_server_ips' => null,
        'email_server_ips' => null,
        'filerd_address' => null,
        'php_version' => null,
        'created_at' => null,
        'app_server_name' => null,
        'db_server_name' => null,
        'email_server_name' => null,
        'backup_server_name' => null,
        'can_use' => null,
        'app_server_ipv6' => 'ipv6',
        'db_server_ipv6' => 'ipv6',
        'email_server_ipv6' => 'ipv6'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'domain' => false,
        'aliases' => false,
        'subdomains' => false,
        'subscription_id' => false,
        'plan_id' => false,
        'plan' => false,
        'status' => false,
        'suspended_by' => false,
        'color_code' => false,
        'tags' => false,
        'size' => false,
        'org_id' => false,
        'org' => false,
        'kind' => false,
        'pending_backup' => false,
        'parent' => false,
        'parent_id' => false,
        'app_server_id' => false,
        'backup_server_id' => false,
        'db_server_id' => false,
        'email_server_id' => false,
        'unix_user' => false,
        'site_access_members' => false,
        'server_ips' => false,
        'backup_server_ips' => false,
        'db_server_ips' => false,
        'email_server_ips' => false,
        'filerd_address' => false,
        'php_version' => false,
        'created_at' => false,
        'app_server_name' => false,
        'db_server_name' => false,
        'email_server_name' => false,
        'backup_server_name' => false,
        'can_use' => false,
        'app_server_ipv6' => false,
        'db_server_ipv6' => false,
        'email_server_ipv6' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'domain' => 'domain',
        'aliases' => 'aliases',
        'subdomains' => 'subdomains',
        'subscription_id' => 'subscriptionId',
        'plan_id' => 'planId',
        'plan' => 'plan',
        'status' => 'status',
        'suspended_by' => 'suspendedBy',
        'color_code' => 'colorCode',
        'tags' => 'tags',
        'size' => 'size',
        'org_id' => 'orgId',
        'org' => 'org',
        'kind' => 'kind',
        'pending_backup' => 'pendingBackup',
        'parent' => 'parent',
        'parent_id' => 'parentId',
        'app_server_id' => 'appServerId',
        'backup_server_id' => 'backupServerId',
        'db_server_id' => 'dbServerId',
        'email_server_id' => 'emailServerId',
        'unix_user' => 'unixUser',
        'site_access_members' => 'siteAccessMembers',
        'server_ips' => 'serverIps',
        'backup_server_ips' => 'backupServerIps',
        'db_server_ips' => 'dbServerIps',
        'email_server_ips' => 'emailServerIps',
        'filerd_address' => 'filerdAddress',
        'php_version' => 'phpVersion',
        'created_at' => 'createdAt',
        'app_server_name' => 'appServerName',
        'db_server_name' => 'dbServerName',
        'email_server_name' => 'emailServerName',
        'backup_server_name' => 'backupServerName',
        'can_use' => 'canUse',
        'app_server_ipv6' => 'appServerIpv6',
        'db_server_ipv6' => 'dbServerIpv6',
        'email_server_ipv6' => 'emailServerIpv6'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'domain' => 'setDomain',
        'aliases' => 'setAliases',
        'subdomains' => 'setSubdomains',
        'subscription_id' => 'setSubscriptionId',
        'plan_id' => 'setPlanId',
        'plan' => 'setPlan',
        'status' => 'setStatus',
        'suspended_by' => 'setSuspendedBy',
        'color_code' => 'setColorCode',
        'tags' => 'setTags',
        'size' => 'setSize',
        'org_id' => 'setOrgId',
        'org' => 'setOrg',
        'kind' => 'setKind',
        'pending_backup' => 'setPendingBackup',
        'parent' => 'setParent',
        'parent_id' => 'setParentId',
        'app_server_id' => 'setAppServerId',
        'backup_server_id' => 'setBackupServerId',
        'db_server_id' => 'setDbServerId',
        'email_server_id' => 'setEmailServerId',
        'unix_user' => 'setUnixUser',
        'site_access_members' => 'setSiteAccessMembers',
        'server_ips' => 'setServerIps',
        'backup_server_ips' => 'setBackupServerIps',
        'db_server_ips' => 'setDbServerIps',
        'email_server_ips' => 'setEmailServerIps',
        'filerd_address' => 'setFilerdAddress',
        'php_version' => 'setPhpVersion',
        'created_at' => 'setCreatedAt',
        'app_server_name' => 'setAppServerName',
        'db_server_name' => 'setDbServerName',
        'email_server_name' => 'setEmailServerName',
        'backup_server_name' => 'setBackupServerName',
        'can_use' => 'setCanUse',
        'app_server_ipv6' => 'setAppServerIpv6',
        'db_server_ipv6' => 'setDbServerIpv6',
        'email_server_ipv6' => 'setEmailServerIpv6'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'domain' => 'getDomain',
        'aliases' => 'getAliases',
        'subdomains' => 'getSubdomains',
        'subscription_id' => 'getSubscriptionId',
        'plan_id' => 'getPlanId',
        'plan' => 'getPlan',
        'status' => 'getStatus',
        'suspended_by' => 'getSuspendedBy',
        'color_code' => 'getColorCode',
        'tags' => 'getTags',
        'size' => 'getSize',
        'org_id' => 'getOrgId',
        'org' => 'getOrg',
        'kind' => 'getKind',
        'pending_backup' => 'getPendingBackup',
        'parent' => 'getParent',
        'parent_id' => 'getParentId',
        'app_server_id' => 'getAppServerId',
        'backup_server_id' => 'getBackupServerId',
        'db_server_id' => 'getDbServerId',
        'email_server_id' => 'getEmailServerId',
        'unix_user' => 'getUnixUser',
        'site_access_members' => 'getSiteAccessMembers',
        'server_ips' => 'getServerIps',
        'backup_server_ips' => 'getBackupServerIps',
        'db_server_ips' => 'getDbServerIps',
        'email_server_ips' => 'getEmailServerIps',
        'filerd_address' => 'getFilerdAddress',
        'php_version' => 'getPhpVersion',
        'created_at' => 'getCreatedAt',
        'app_server_name' => 'getAppServerName',
        'db_server_name' => 'getDbServerName',
        'email_server_name' => 'getEmailServerName',
        'backup_server_name' => 'getBackupServerName',
        'can_use' => 'getCanUse',
        'app_server_ipv6' => 'getAppServerIpv6',
        'db_server_ipv6' => 'getDbServerIpv6',
        'email_server_ipv6' => 'getEmailServerIpv6'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('domain', $data ?? [], null);
        $this->setIfExists('aliases', $data ?? [], null);
        $this->setIfExists('subdomains', $data ?? [], null);
        $this->setIfExists('subscription_id', $data ?? [], null);
        $this->setIfExists('plan_id', $data ?? [], null);
        $this->setIfExists('plan', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('suspended_by', $data ?? [], null);
        $this->setIfExists('color_code', $data ?? [], null);
        $this->setIfExists('tags', $data ?? [], null);
        $this->setIfExists('size', $data ?? [], null);
        $this->setIfExists('org_id', $data ?? [], null);
        $this->setIfExists('org', $data ?? [], null);
        $this->setIfExists('kind', $data ?? [], null);
        $this->setIfExists('pending_backup', $data ?? [], null);
        $this->setIfExists('parent', $data ?? [], null);
        $this->setIfExists('parent_id', $data ?? [], null);
        $this->setIfExists('app_server_id', $data ?? [], null);
        $this->setIfExists('backup_server_id', $data ?? [], null);
        $this->setIfExists('db_server_id', $data ?? [], null);
        $this->setIfExists('email_server_id', $data ?? [], null);
        $this->setIfExists('unix_user', $data ?? [], null);
        $this->setIfExists('site_access_members', $data ?? [], null);
        $this->setIfExists('server_ips', $data ?? [], null);
        $this->setIfExists('backup_server_ips', $data ?? [], null);
        $this->setIfExists('db_server_ips', $data ?? [], null);
        $this->setIfExists('email_server_ips', $data ?? [], null);
        $this->setIfExists('filerd_address', $data ?? [], null);
        $this->setIfExists('php_version', $data ?? [], null);
        $this->setIfExists('created_at', $data ?? [], null);
        $this->setIfExists('app_server_name', $data ?? [], null);
        $this->setIfExists('db_server_name', $data ?? [], null);
        $this->setIfExists('email_server_name', $data ?? [], null);
        $this->setIfExists('backup_server_name', $data ?? [], null);
        $this->setIfExists('can_use', $data ?? [], null);
        $this->setIfExists('app_server_ipv6', $data ?? [], null);
        $this->setIfExists('db_server_ipv6', $data ?? [], null);
        $this->setIfExists('email_server_ipv6', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['domain'] === null) {
            $invalidProperties[] = "'domain' can't be null";
        }
        if ($this->container['aliases'] === null) {
            $invalidProperties[] = "'aliases' can't be null";
        }
        if ($this->container['subdomains'] === null) {
            $invalidProperties[] = "'subdomains' can't be null";
        }
        if ($this->container['status'] === null) {
            $invalidProperties[] = "'status' can't be null";
        }
        if ($this->container['color_code'] === null) {
            $invalidProperties[] = "'color_code' can't be null";
        }
        if ($this->container['size'] === null) {
            $invalidProperties[] = "'size' can't be null";
        }
        if ($this->container['org_id'] === null) {
            $invalidProperties[] = "'org_id' can't be null";
        }
        if ($this->container['kind'] === null) {
            $invalidProperties[] = "'kind' can't be null";
        }
        if ($this->container['created_at'] === null) {
            $invalidProperties[] = "'created_at' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets domain
     *
     * @return \OpenAPI\Client\Model\WebsiteDomain
     */
    public function getDomain()
    {
        return $this->container['domain'];
    }

    /**
     * Sets domain
     *
     * @param \OpenAPI\Client\Model\WebsiteDomain $domain domain
     *
     * @return self
     */
    public function setDomain($domain)
    {
        if (is_null($domain)) {
            throw new \InvalidArgumentException('non-nullable domain cannot be null');
        }
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets aliases
     *
     * @return \OpenAPI\Client\Model\WebsiteDomain[]
     */
    public function getAliases()
    {
        return $this->container['aliases'];
    }

    /**
     * Sets aliases
     *
     * @param \OpenAPI\Client\Model\WebsiteDomain[] $aliases aliases
     *
     * @return self
     */
    public function setAliases($aliases)
    {
        if (is_null($aliases)) {
            throw new \InvalidArgumentException('non-nullable aliases cannot be null');
        }
        $this->container['aliases'] = $aliases;

        return $this;
    }

    /**
     * Gets subdomains
     *
     * @return mixed[]
     */
    public function getSubdomains()
    {
        return $this->container['subdomains'];
    }

    /**
     * Sets subdomains
     *
     * @param mixed[] $subdomains subdomains
     *
     * @return self
     */
    public function setSubdomains($subdomains)
    {
        if (is_null($subdomains)) {
            throw new \InvalidArgumentException('non-nullable subdomains cannot be null');
        }
        $this->container['subdomains'] = $subdomains;

        return $this;
    }

    /**
     * Gets subscription_id
     *
     * @return float|null
     */
    public function getSubscriptionId()
    {
        return $this->container['subscription_id'];
    }

    /**
     * Sets subscription_id
     *
     * @param float|null $subscription_id subscription_id
     *
     * @return self
     */
    public function setSubscriptionId($subscription_id)
    {
        if (is_null($subscription_id)) {
            throw new \InvalidArgumentException('non-nullable subscription_id cannot be null');
        }
        $this->container['subscription_id'] = $subscription_id;

        return $this;
    }

    /**
     * Gets plan_id
     *
     * @return float|null
     */
    public function getPlanId()
    {
        return $this->container['plan_id'];
    }

    /**
     * Sets plan_id
     *
     * @param float|null $plan_id plan_id
     *
     * @return self
     */
    public function setPlanId($plan_id)
    {
        if (is_null($plan_id)) {
            throw new \InvalidArgumentException('non-nullable plan_id cannot be null');
        }
        $this->container['plan_id'] = $plan_id;

        return $this;
    }

    /**
     * Gets plan
     *
     * @return string|null
     */
    public function getPlan()
    {
        return $this->container['plan'];
    }

    /**
     * Sets plan
     *
     * @param string|null $plan plan
     *
     * @return self
     */
    public function setPlan($plan)
    {
        if (is_null($plan)) {
            throw new \InvalidArgumentException('non-nullable plan cannot be null');
        }
        $this->container['plan'] = $plan;

        return $this;
    }

    /**
     * Gets status
     *
     * @return \OpenAPI\Client\Model\WebsiteStatus
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param \OpenAPI\Client\Model\WebsiteStatus $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets suspended_by
     *
     * @return string|null
     */
    public function getSuspendedBy()
    {
        return $this->container['suspended_by'];
    }

    /**
     * Sets suspended_by
     *
     * @param string|null $suspended_by suspended_by
     *
     * @return self
     */
    public function setSuspendedBy($suspended_by)
    {
        if (is_null($suspended_by)) {
            throw new \InvalidArgumentException('non-nullable suspended_by cannot be null');
        }
        $this->container['suspended_by'] = $suspended_by;

        return $this;
    }

    /**
     * Gets color_code
     *
     * @return string
     */
    public function getColorCode()
    {
        return $this->container['color_code'];
    }

    /**
     * Sets color_code
     *
     * @param string $color_code color_code
     *
     * @return self
     */
    public function setColorCode($color_code)
    {
        if (is_null($color_code)) {
            throw new \InvalidArgumentException('non-nullable color_code cannot be null');
        }
        $this->container['color_code'] = $color_code;

        return $this;
    }

    /**
     * Gets tags
     *
     * @return \OpenAPI\Client\Model\Tag[]|null
     */
    public function getTags()
    {
        return $this->container['tags'];
    }

    /**
     * Sets tags
     *
     * @param \OpenAPI\Client\Model\Tag[]|null $tags tags
     *
     * @return self
     */
    public function setTags($tags)
    {
        if (is_null($tags)) {
            throw new \InvalidArgumentException('non-nullable tags cannot be null');
        }
        $this->container['tags'] = $tags;

        return $this;
    }

    /**
     * Gets size
     *
     * @return int
     */
    public function getSize()
    {
        return $this->container['size'];
    }

    /**
     * Sets size
     *
     * @param int $size size
     *
     * @return self
     */
    public function setSize($size)
    {
        if (is_null($size)) {
            throw new \InvalidArgumentException('non-nullable size cannot be null');
        }
        $this->container['size'] = $size;

        return $this;
    }

    /**
     * Gets org_id
     *
     * @return string
     */
    public function getOrgId()
    {
        return $this->container['org_id'];
    }

    /**
     * Sets org_id
     *
     * @param string $org_id org_id
     *
     * @return self
     */
    public function setOrgId($org_id)
    {
        if (is_null($org_id)) {
            throw new \InvalidArgumentException('non-nullable org_id cannot be null');
        }
        $this->container['org_id'] = $org_id;

        return $this;
    }

    /**
     * Gets org
     *
     * @return string|null
     */
    public function getOrg()
    {
        return $this->container['org'];
    }

    /**
     * Sets org
     *
     * @param string|null $org org
     *
     * @return self
     */
    public function setOrg($org)
    {
        if (is_null($org)) {
            throw new \InvalidArgumentException('non-nullable org cannot be null');
        }
        $this->container['org'] = $org;

        return $this;
    }

    /**
     * Gets kind
     *
     * @return \OpenAPI\Client\Model\WebsiteKind
     */
    public function getKind()
    {
        return $this->container['kind'];
    }

    /**
     * Sets kind
     *
     * @param \OpenAPI\Client\Model\WebsiteKind $kind kind
     *
     * @return self
     */
    public function setKind($kind)
    {
        if (is_null($kind)) {
            throw new \InvalidArgumentException('non-nullable kind cannot be null');
        }
        $this->container['kind'] = $kind;

        return $this;
    }

    /**
     * Gets pending_backup
     *
     * @return \OpenAPI\Client\Model\BackupAction|null
     */
    public function getPendingBackup()
    {
        return $this->container['pending_backup'];
    }

    /**
     * Sets pending_backup
     *
     * @param \OpenAPI\Client\Model\BackupAction|null $pending_backup pending_backup
     *
     * @return self
     */
    public function setPendingBackup($pending_backup)
    {
        if (is_null($pending_backup)) {
            throw new \InvalidArgumentException('non-nullable pending_backup cannot be null');
        }
        $this->container['pending_backup'] = $pending_backup;

        return $this;
    }

    /**
     * Gets parent
     *
     * @return string|null
     */
    public function getParent()
    {
        return $this->container['parent'];
    }

    /**
     * Sets parent
     *
     * @param string|null $parent parent
     *
     * @return self
     */
    public function setParent($parent)
    {
        if (is_null($parent)) {
            throw new \InvalidArgumentException('non-nullable parent cannot be null');
        }
        $this->container['parent'] = $parent;

        return $this;
    }

    /**
     * Gets parent_id
     *
     * @return string|null
     */
    public function getParentId()
    {
        return $this->container['parent_id'];
    }

    /**
     * Sets parent_id
     *
     * @param string|null $parent_id parent_id
     *
     * @return self
     */
    public function setParentId($parent_id)
    {
        if (is_null($parent_id)) {
            throw new \InvalidArgumentException('non-nullable parent_id cannot be null');
        }
        $this->container['parent_id'] = $parent_id;

        return $this;
    }

    /**
     * Gets app_server_id
     *
     * @return string|null
     */
    public function getAppServerId()
    {
        return $this->container['app_server_id'];
    }

    /**
     * Sets app_server_id
     *
     * @param string|null $app_server_id The id of the server on which this website is located. This is only returned when websites are queried recursively by an MO member, as the MO is in charge of servers and thus this information only concerns them.
     *
     * @return self
     */
    public function setAppServerId($app_server_id)
    {
        if (is_null($app_server_id)) {
            throw new \InvalidArgumentException('non-nullable app_server_id cannot be null');
        }
        $this->container['app_server_id'] = $app_server_id;

        return $this;
    }

    /**
     * Gets backup_server_id
     *
     * @return string|null
     */
    public function getBackupServerId()
    {
        return $this->container['backup_server_id'];
    }

    /**
     * Sets backup_server_id
     *
     * @param string|null $backup_server_id The id of the server on which the backups of this website are located. This is only returned when websites are queried recursively by an MO member, as the MO is in charge of servers and thus this information only concerns them.
     *
     * @return self
     */
    public function setBackupServerId($backup_server_id)
    {
        if (is_null($backup_server_id)) {
            throw new \InvalidArgumentException('non-nullable backup_server_id cannot be null');
        }
        $this->container['backup_server_id'] = $backup_server_id;

        return $this;
    }

    /**
     * Gets db_server_id
     *
     * @return string|null
     */
    public function getDbServerId()
    {
        return $this->container['db_server_id'];
    }

    /**
     * Sets db_server_id
     *
     * @param string|null $db_server_id The id of the server on which the databases of this website are located. This is only returned when websites are queried recursively by an MO member, as the MO is in charge of servers and thus this information only concerns them.
     *
     * @return self
     */
    public function setDbServerId($db_server_id)
    {
        if (is_null($db_server_id)) {
            throw new \InvalidArgumentException('non-nullable db_server_id cannot be null');
        }
        $this->container['db_server_id'] = $db_server_id;

        return $this;
    }

    /**
     * Gets email_server_id
     *
     * @return string|null
     */
    public function getEmailServerId()
    {
        return $this->container['email_server_id'];
    }

    /**
     * Sets email_server_id
     *
     * @param string|null $email_server_id The id of the server on which the emails of this website are located. This is only returned when websites are queried recursively by an MO member, as the MO is in charge of servers and thus this information only concerns them.
     *
     * @return self
     */
    public function setEmailServerId($email_server_id)
    {
        if (is_null($email_server_id)) {
            throw new \InvalidArgumentException('non-nullable email_server_id cannot be null');
        }
        $this->container['email_server_id'] = $email_server_id;

        return $this;
    }

    /**
     * Gets unix_user
     *
     * @return string|null
     */
    public function getUnixUser()
    {
        return $this->container['unix_user'];
    }

    /**
     * Sets unix_user
     *
     * @param string|null $unix_user The unix user assigned to this website, used for ssh shells, prefixing website databases and databse users, etc.
     *
     * @return self
     */
    public function setUnixUser($unix_user)
    {
        if (is_null($unix_user)) {
            throw new \InvalidArgumentException('non-nullable unix_user cannot be null');
        }
        $this->container['unix_user'] = $unix_user;

        return $this;
    }

    /**
     * Gets site_access_members
     *
     * @return \OpenAPI\Client\Model\SiteAccessMember[]|null
     */
    public function getSiteAccessMembers()
    {
        return $this->container['site_access_members'];
    }

    /**
     * Sets site_access_members
     *
     * @param \OpenAPI\Client\Model\SiteAccessMember[]|null $site_access_members site_access_members
     *
     * @return self
     */
    public function setSiteAccessMembers($site_access_members)
    {
        if (is_null($site_access_members)) {
            throw new \InvalidArgumentException('non-nullable site_access_members cannot be null');
        }
        $this->container['site_access_members'] = $site_access_members;

        return $this;
    }

    /**
     * Gets server_ips
     *
     * @return \OpenAPI\Client\Model\ServerIp[]|null
     */
    public function getServerIps()
    {
        return $this->container['server_ips'];
    }

    /**
     * Sets server_ips
     *
     * @param \OpenAPI\Client\Model\ServerIp[]|null $server_ips The addresses of the the server on which this website is located.
     *
     * @return self
     */
    public function setServerIps($server_ips)
    {
        if (is_null($server_ips)) {
            throw new \InvalidArgumentException('non-nullable server_ips cannot be null');
        }
        $this->container['server_ips'] = $server_ips;

        return $this;
    }

    /**
     * Gets backup_server_ips
     *
     * @return \OpenAPI\Client\Model\ServerIp[]|null
     */
    public function getBackupServerIps()
    {
        return $this->container['backup_server_ips'];
    }

    /**
     * Sets backup_server_ips
     *
     * @param \OpenAPI\Client\Model\ServerIp[]|null $backup_server_ips The addresses of the the server on which this website's backups are located.
     *
     * @return self
     */
    public function setBackupServerIps($backup_server_ips)
    {
        if (is_null($backup_server_ips)) {
            throw new \InvalidArgumentException('non-nullable backup_server_ips cannot be null');
        }
        $this->container['backup_server_ips'] = $backup_server_ips;

        return $this;
    }

    /**
     * Gets db_server_ips
     *
     * @return \OpenAPI\Client\Model\ServerIp[]|null
     */
    public function getDbServerIps()
    {
        return $this->container['db_server_ips'];
    }

    /**
     * Sets db_server_ips
     *
     * @param \OpenAPI\Client\Model\ServerIp[]|null $db_server_ips The addresses of the the server on which this website's databases are located.
     *
     * @return self
     */
    public function setDbServerIps($db_server_ips)
    {
        if (is_null($db_server_ips)) {
            throw new \InvalidArgumentException('non-nullable db_server_ips cannot be null');
        }
        $this->container['db_server_ips'] = $db_server_ips;

        return $this;
    }

    /**
     * Gets email_server_ips
     *
     * @return \OpenAPI\Client\Model\ServerIp[]|null
     */
    public function getEmailServerIps()
    {
        return $this->container['email_server_ips'];
    }

    /**
     * Sets email_server_ips
     *
     * @param \OpenAPI\Client\Model\ServerIp[]|null $email_server_ips The addresses of the the server on which this website's emails are located.
     *
     * @return self
     */
    public function setEmailServerIps($email_server_ips)
    {
        if (is_null($email_server_ips)) {
            throw new \InvalidArgumentException('non-nullable email_server_ips cannot be null');
        }
        $this->container['email_server_ips'] = $email_server_ips;

        return $this;
    }

    /**
     * Gets filerd_address
     *
     * @return string|null
     */
    public function getFilerdAddress()
    {
        return $this->container['filerd_address'];
    }

    /**
     * Sets filerd_address
     *
     * @param string|null $filerd_address The path relative to the control panel domain where filerd can be accessed.
     *
     * @return self
     */
    public function setFilerdAddress($filerd_address)
    {
        if (is_null($filerd_address)) {
            throw new \InvalidArgumentException('non-nullable filerd_address cannot be null');
        }
        $this->container['filerd_address'] = $filerd_address;

        return $this;
    }

    /**
     * Gets php_version
     *
     * @return \OpenAPI\Client\Model\PhpVersion|null
     */
    public function getPhpVersion()
    {
        return $this->container['php_version'];
    }

    /**
     * Sets php_version
     *
     * @param \OpenAPI\Client\Model\PhpVersion|null $php_version php_version
     *
     * @return self
     */
    public function setPhpVersion($php_version)
    {
        if (is_null($php_version)) {
            throw new \InvalidArgumentException('non-nullable php_version cannot be null');
        }
        $this->container['php_version'] = $php_version;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string $created_at The date the site was first added
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        if (is_null($created_at)) {
            throw new \InvalidArgumentException('non-nullable created_at cannot be null');
        }
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets app_server_name
     *
     * @return string|null
     */
    public function getAppServerName()
    {
        return $this->container['app_server_name'];
    }

    /**
     * Sets app_server_name
     *
     * @param string|null $app_server_name app_server_name
     *
     * @return self
     */
    public function setAppServerName($app_server_name)
    {
        if (is_null($app_server_name)) {
            throw new \InvalidArgumentException('non-nullable app_server_name cannot be null');
        }
        $this->container['app_server_name'] = $app_server_name;

        return $this;
    }

    /**
     * Gets db_server_name
     *
     * @return string|null
     */
    public function getDbServerName()
    {
        return $this->container['db_server_name'];
    }

    /**
     * Sets db_server_name
     *
     * @param string|null $db_server_name db_server_name
     *
     * @return self
     */
    public function setDbServerName($db_server_name)
    {
        if (is_null($db_server_name)) {
            throw new \InvalidArgumentException('non-nullable db_server_name cannot be null');
        }
        $this->container['db_server_name'] = $db_server_name;

        return $this;
    }

    /**
     * Gets email_server_name
     *
     * @return string|null
     */
    public function getEmailServerName()
    {
        return $this->container['email_server_name'];
    }

    /**
     * Sets email_server_name
     *
     * @param string|null $email_server_name email_server_name
     *
     * @return self
     */
    public function setEmailServerName($email_server_name)
    {
        if (is_null($email_server_name)) {
            throw new \InvalidArgumentException('non-nullable email_server_name cannot be null');
        }
        $this->container['email_server_name'] = $email_server_name;

        return $this;
    }

    /**
     * Gets backup_server_name
     *
     * @return string|null
     */
    public function getBackupServerName()
    {
        return $this->container['backup_server_name'];
    }

    /**
     * Sets backup_server_name
     *
     * @param string|null $backup_server_name backup_server_name
     *
     * @return self
     */
    public function setBackupServerName($backup_server_name)
    {
        if (is_null($backup_server_name)) {
            throw new \InvalidArgumentException('non-nullable backup_server_name cannot be null');
        }
        $this->container['backup_server_name'] = $backup_server_name;

        return $this;
    }

    /**
     * Gets can_use
     *
     * @return \OpenAPI\Client\Model\CanUse|null
     */
    public function getCanUse()
    {
        return $this->container['can_use'];
    }

    /**
     * Sets can_use
     *
     * @param \OpenAPI\Client\Model\CanUse|null $can_use can_use
     *
     * @return self
     */
    public function setCanUse($can_use)
    {
        if (is_null($can_use)) {
            throw new \InvalidArgumentException('non-nullable can_use cannot be null');
        }
        $this->container['can_use'] = $can_use;

        return $this;
    }

    /**
     * Gets app_server_ipv6
     *
     * @return string|null
     */
    public function getAppServerIpv6()
    {
        return $this->container['app_server_ipv6'];
    }

    /**
     * Sets app_server_ipv6
     *
     * @param string|null $app_server_ipv6 app_server_ipv6
     *
     * @return self
     */
    public function setAppServerIpv6($app_server_ipv6)
    {
        if (is_null($app_server_ipv6)) {
            throw new \InvalidArgumentException('non-nullable app_server_ipv6 cannot be null');
        }
        $this->container['app_server_ipv6'] = $app_server_ipv6;

        return $this;
    }

    /**
     * Gets db_server_ipv6
     *
     * @return string|null
     */
    public function getDbServerIpv6()
    {
        return $this->container['db_server_ipv6'];
    }

    /**
     * Sets db_server_ipv6
     *
     * @param string|null $db_server_ipv6 db_server_ipv6
     *
     * @return self
     */
    public function setDbServerIpv6($db_server_ipv6)
    {
        if (is_null($db_server_ipv6)) {
            throw new \InvalidArgumentException('non-nullable db_server_ipv6 cannot be null');
        }
        $this->container['db_server_ipv6'] = $db_server_ipv6;

        return $this;
    }

    /**
     * Gets email_server_ipv6
     *
     * @return string|null
     */
    public function getEmailServerIpv6()
    {
        return $this->container['email_server_ipv6'];
    }

    /**
     * Sets email_server_ipv6
     *
     * @param string|null $email_server_ipv6 email_server_ipv6
     *
     * @return self
     */
    public function setEmailServerIpv6($email_server_ipv6)
    {
        if (is_null($email_server_ipv6)) {
            throw new \InvalidArgumentException('non-nullable email_server_ipv6 cannot be null');
        }
        $this->container['email_server_ipv6'] = $email_server_ipv6;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


