(function ($, w, d) {
  // ensure global
  w.clientexec = w.clientexec || {};

  $(function () {
    if (w.clientexec.sessionHash) {
      $.ajaxSetup({
        headers: { 'X-Session-Hash': w.clientexec.sessionHash }
      });

      $(d).on('submit', 'form', function () {
        if (!this.querySelector('input[name="sessionHash"]')) {
          $('<input>', {
            type: 'hidden',
            name: 'sessionHash',
            value: w.clientexec.sessionHash
          }).appendTo(this);
        }
      });
    }

    if (w.clientexec.overlayTpl) {
      $('body').append(w.clientexec.overlayTpl);
    }
  });
})(jQuery, window, document);


clientexec._sprintf = function(s) {
    var re = /%/;
    var i = 0;
    while (re.test(s)) {
        arg = clientexec._sprintf.arguments[++i];
        if (typeof arg == "undefined") {
            break;
        }
        s = s.replace(re, arg);
    }
    return s;
}

clientexec.lang = function(phrase) {
    if ((typeof language != "undefined") && (typeof language[phrase] != "undefined") && (language[phrase] != '')) {
        switch (clientexec.lang.arguments.length) {
            case 1:
                return language[phrase];
            case 2:
                return clientexec._sprintf(language[phrase], clientexec.lang.arguments[1]);
            case 3:
                return clientexec._sprintf(language[phrase], clientexec.lang.arguments[1], clientexec.lang.arguments[2]);
            case 4:
                return clientexec._sprintf(language[phrase], clientexec.lang.arguments[1], clientexec.lang.arguments[2], clientexec.lang.arguments[3]);
        }

        return language[phrase];
    }

    switch (clientexec.lang.arguments.length) {
        case 1:
            return phrase;
        case 2:
            return clientexec._sprintf(phrase, clientexec.lang.arguments[1]);
        case 3:
            return clientexec._sprintf(phrase, clientexec.lang.arguments[1], clientexec.lang.arguments[2]);
        case 4:
            return clientexec._sprintf(phrase, clientexec.lang.arguments[1], clientexec.lang.arguments[2], clientexec.lang.arguments[3]);
    }

    return phrase;
}

clientexec.htmlspecialchars = function(txt, onlyAmpersand) {
    if (!txt) return '';
    txt = txt.replace(/&/g, "&amp;");
    if (onlyAmpersand) {
        return txt
    }
    return txt
        .replace(/</g, "&lt;")
        .replace(/>/g, "&gt;")
        .replace(/"/g, "&quot;")
        .replace(/'/g, "&#039;");
}

clientexec.postPageLoad = function(parent) {
    if (!parent) {
        parent = 'body';
    }

    if ($(parent + " .normalSelect2").exists()) {
        $('.normalSelect2').select2({
            minimumResultsForSearch: -1,
            width: '100%'
        });
    }
    if ($(parent + " .searchSelect2").exists()) {
        $('.searchSelect2').select2({});
    }

    if ($(parent + " .multiSelect").exists()) {
        $(".multiSelect").select2({
            tags: true,
            tokenSeparators: [',', ' ']
        })
    }

    if ($(parent + ' .datePicker').exists()) {
        $('.datePicker').datepicker({
            format: clientexec.dateformat,
            autoclose: true
        });
    }

    if ($(parent + ' [data-bs-toggle="tooltip"]').length) {
        $(parent + ' [data-bs-toggle="tooltip"]').each(function () {
            new bootstrap.Tooltip(this);
        });
    }
}

clientexec.overlayTpl = '<div id="ce-overlay" style="display:none;left:-999999px;"></div><div id="ce-overlay-inner" style="display:none;left:-999999px;"></div>';
clientexec.mask = function(selector, fade) {
    if (!fade) {
        fade = false;
    }
    if ((!selector) || selector === null) {
        selector = "body";
    }

    var $t, height, width;
    $t = $(selector);
    height = $(document).height()
    width = $t.outerWidth();

    $("#ce-overlay").css({
        top     : $t.offset().top,
        left    : $t.offset().left,
        width   : width,
        height  : height,
        display : '',
        position: 'fixed'
    });

    if (fade) {
        $("#ce-overlay").fadeIn('slow');
    } else {
        $("#ce-overlay").show();
    }
}
clientexec.unMask =function() {
    $("#ce-overlay").fadeOut();
    $("#ce-overlay").css({display:'none',left:'-999999px'});
}

clientexec.parseResponse = function(response, display, msg) {
    if (display == undefined) {
        display = true;
    }

    try {
        if (typeof(response.error) != "undefined" && response.error) {
            var error;

            if ((response.message != "") && display) {
                error = response.message;
                error = clientexec.htmlspecialchars(error);
                error = error.replace(/\n/gi, "<br /> \n");
                clientexec.showNotification(error, 'danger');
            } else if (display) {
                error = "There was an error performing this action";
                if (msg != undefined) {
                    error = msg;
                }
                clientexec.showNotification(error, 'danger');
            }

            response = new Object();
            response.error = true;
            response.message = error;
        } else if (typeof(response.error) == "undefined") {
            response = new Object();
            response.error = true;
            clientexec.showNotification("Data returned seems to be pure html", 'danger');
        } else {
            //no errors maybe msgbox
            if ((response.message != "") && display) {
                message = clientexec.htmlspecialchars(response.message);
                clientexec.showNotification(message);
            }
        }
    } catch(e) {
        response = new Object();
        response.error = true;
        response.message = "Data returned is not valid json<br/>"+e.toString()+'<br />'+response;
        if (display) {
            clientexec.showNotification(response.message, 'danger');
        }
    }
    return response;
}

clientexec.msg = function(message) {
    clientexec.showNotification(message, "info");

}

clientexec.error = function(message) {
    clientexec.showNotification(message, "danger");

}

// @see http://phpjs.org/functions/strip_tags/
clientexec.strip_tags = function(input, allowed) {
    allowed = (((allowed || "") + "").toLowerCase().match(/<[a-z][a-z0-9]*>/g) || []).join(''); // making sure the allowed arg is a string containing only tags in lowercase (<a><b><c>)
    var tags = /<\/?([a-z][a-z0-9]*)\b[^>]*>/gi,
        commentsAndPhpTags = /<!--[\s\S]*?-->|<\?(?:php)?[\s\S]*?\?>/gi;
    return input.replace(commentsAndPhpTags, '').replace(tags, function ($0, $1) {
        return allowed.indexOf('<' + $1.toLowerCase() + '>') > -1 ? $0 : '';
    });
}


clientexec.checkListsStates = function ()
{
    // Get the country and state information
    var selectStates = '';
    var stateIso = '';
    var countryIso = '';

    if (typeof stateVAR != 'undefined' && mainForm.elements[stateVAR] != null) {
        selectStates = $('#' + stateVAR);
        stateIso = mainForm.elements[stateVAR].value;
    }

    if (typeof countryVAR != 'undefined' && mainForm.elements[countryVAR] != null) {
        countryIso = mainForm.elements[countryVAR].value;
    }


    if (countryIso != '' && selectStates != '' && currentCountry != countryIso) {
        selectStates.empty();
        currentCountry = countryIso;

        $.getJSON('index.php?fuse=admin&controller=settings&action=getstatelist&countryIso='+countryIso+'&stateIso='+stateIso+'&displayAll=0', function(response) {

            if (response.totalcount == 0) {
                selectStates.val(null);
            } else {
                for (var k in response.states) {
                    var option = new Option(response.states[k].name, response.states[k].iso);
                    selectStates.append(option);
                }
            }

            selectStates.trigger('change');
        });
    }
}


clientexec.getTax = function(mainForm)
{

    if (typeof mainForm === 'undefined') {
        var mainForm = document.forms['customerdata'];
    }

    var country = "";
    var state = "";

    if (typeof countryVAR != 'undefined' && mainForm.elements[countryVAR] != null) {
        country = mainForm.elements[countryVAR].value;
    }

    if (typeof stateVAR != 'undefined' && mainForm.elements[stateVAR] != null) {
        state = mainForm.elements[stateVAR].value;
    }

    if (country) {
        $.ajax({
            url: 'index.php?fuse=clients&controller=user&action=gettax&country='+country+'&state='+state+'&ignoreuser=1',
            dataType: 'json',
            success: function (data) {
                clientexec.setTax(data, mainForm);
            }

        });
    } else {
        if (typeof vatVAR != 'undefined' && mainForm.elements[vatVAR] != null) {
            mainForm.elements[vatVAR].disabled = true;
        }

        if (document.getElementById('vatBlock') != undefined) {
            document.getElementById('vatBlock').style.display = 'none';
        }
    }
}

clientexec.setTax = function(responseObj, mainForm)
{
    json = clientexec.parseResponse(responseObj);

    if (typeof vatVAR != 'undefined' && mainForm.elements[vatVAR] != null) {
        if (json.taxes.isEUcountry) {
            mainForm.elements[vatVAR].disabled = false;

            if (document.getElementById('vatBlock') != undefined) {
                document.getElementById('vatBlock').style.display = '';
            }

            clientexec.checkVAT();
        } else {
            mainForm.elements[vatVAR].disabled = true;

            if (document.getElementById('vatBlock') != undefined) {
                document.getElementById('vatBlock').style.display = 'none';
            }
        }
    } else {
        if (document.getElementById('vatBlock') != undefined) {
            document.getElementById('vatBlock').style.display='none';
        }
    }
}

clientexec.checkVAT = function()
{
    if (document.getElementById('vat_validating') != undefined) {
        document.getElementById('vat_validating').style.display = '';
        document.getElementById('vat_valid').style.display = 'none';
        document.getElementById('vat_invalid').style.display = 'none';
        document.getElementById('vat_error').style.display = 'none';
    }

    var country = '';
    var vatnum = '';

    if (typeof countryVAR != 'undefined' && mainForm.elements[countryVAR] != null) {
        country = mainForm.elements[countryVAR].value;
    }

    if (document.getElementById('vat_country') != undefined) {
        // Greece has to be different...
        if (country == 'GR') {
            document.getElementById('vat_country').innerHTML = 'EL';
        } else {
            document.getElementById('vat_country').innerHTML = country;
        }
    }

    if (typeof vatVAR != 'undefined' && mainForm.elements[vatVAR] != null && mainForm.elements[vatVAR].value != '') {
        vatnum = mainForm.elements[vatVAR].value;
    }

    if (country) {
        appendToRequest = '';

        if (mainForm.elements['userid'] != undefined) {
            appendToRequest = '&userid='+mainForm.elements['userid'].value;
        }

        $.ajax({
           url: 'index.php?fuse=billing&action=checkvat&country='+country+'&vat='+vatnum+'&ignoreuser=1'+appendToRequest,
           dataType: 'json',
           success: clientexec.checkVAT_Callback
        });
    } else {
        if (document.getElementById('vat_validating') != undefined) {
            document.getElementById('vat_validating').style.display = 'none';
            document.getElementById('vat_valid').style.display = 'none';
            document.getElementById('vat_invalid').style.display = 'none';
            document.getElementById('vat_error').style.display = 'none';
        }

        if (typeof vatVAR != 'undefined' && mainForm.elements[vatVAR] != null) {
            mainForm.elements[vatVAR].disabled = true;
            mainForm.elements[vatVAR].value = '';
        }

        if (document.getElementById('vatBlock') != undefined) {
            document.getElementById('vatBlock').style.display = 'none';
        }
    }
}

clientexec.checkVAT_Callback = function(responseObj)
{
    respArr = responseObj.responseText.split("|");

    if (respArr[1] != "" && typeof vatVAR != 'undefined' && mainForm.elements[vatVAR] != null && mainForm.elements[vatVAR].value == '') {
        mainForm.elements[vatVAR].value = respArr[1];
    }

    if (document.getElementById('vat_validating') != undefined) {
        document.getElementById('vat_validating').style.display = 'none';

        if (respArr[1] != "") {
            switch (respArr[0]) {
                case "-1":
                    document.getElementById('vat_error').style.display = '';
                    break;
                case "0":
                    document.getElementById('vat_invalid').style.display = '';
                    break;
                case "1":
                    document.getElementById('vat_valid').style.display = '';
                    break;
            }
        }
    }
}

clientexec.nl2br = function (string) {
    var test = string.replace(/\n/g, function (match, offset) {
        var before = string[offset - 1];
        var after = string[offset + 1];

        // If newline is between tags or next to a tag, skip it
        if (before === '>' || after === '<') {
            return '\n';
        }

        return '<br>\n';
    });
    console.log(test);
    return test;
};


clientexec.html_entity_decode = function(str) {
    return String(str).replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;');
}

clientexec.htmlentities = function(html) {
    return $('<div/>').text(html).html();
}

clientexec.unhtmlentities = function(text) {
    return $('<div/>').html(text).text();
}

clientexec.createPluginInput = function (inputObj) {
    var $input;
    var $wrapper;

    switch (inputObj.type) {
        case 'text':
        case 'hidden':
        case 'password':
            $input = $('<input>', {
                id: 'input' + inputObj.name,
                name: inputObj.name,
                type: inputObj.type,
                class: 'form-control',
                title: inputObj.description,
                value: inputObj.value
            });
            $wrapper = $('<div>', { class: 'mb-3' })
                .append(
                    $('<label>', {
                        class: 'form-label',
                        for: 'input' + inputObj.name,
                        text: inputObj.label,
                        'data-bs-toggle': 'tooltip',
                        'data-bs-html': 'true',
                        title: inputObj.description
                    }),
                    $input
                );
            break;

        case 'textarea':
            $input = $('<textarea>', {
                rows: 5,
                id: 'textarea' + inputObj.name,
                name: inputObj.name,
                class: 'form-control',
                title: inputObj.description
            }).val(inputObj.value);
            $wrapper = $('<div>', { class: 'mb-3' })
                .append(
                    $('<label>', {
                        class: 'form-label',
                        for: 'textarea' + inputObj.name,
                        text: inputObj.label,
                        'data-bs-toggle': 'tooltip',
                        'data-bs-html': 'true',
                        title: inputObj.description
                    }),
                    $input
                );
            break;

        case 'checkbox':
        case 'yesno':
            $input = $('<select>', {
                id: 'select' + inputObj.name,
                name: inputObj.name,
                class: 'form-select',
                title: inputObj.description
            }).append(
                $('<option>', { value: 1, text: 'Yes' }),
                $('<option>', { value: 0, text: 'No' })
            ).val(inputObj.value);

            $wrapper = $('<div>', { class: 'mb-3' })
                .append(
                    $('<label>', {
                        class: 'form-label',
                        for: 'select' + inputObj.name,
                        text: inputObj.label,
                        'data-bs-toggle': 'tooltip',
                        'data-bs-html': 'true',
                        title: inputObj.description
                    }),
                    $input
                );
            break;

        default:
            return false;
    }

    // wrap into a col-md-6 so we can align 2 per row
    return $('<div>', { class: 'col-md-6' }).append($wrapper);
};

clientexec.lazyLoad = function() {
    var last3Char,url;
    // best way to check if something is not an array
    if (Object.prototype.toString.apply(arguments[0]) !== '[object Array]') {
        arguments[0] = [arguments[0]];
    }

    for (var i = 0; i < arguments[0].length; i++) {
        //if last 3 chars are .js then do ?
        //else we need to assume there are other args and pass &
        //

        url = arguments[0][i];
        if (clientexec.disableCache == false) {
            if (url.indexOf("?") < 0) {
                arguments[0][i] += '?ver=' + clientexec.version;
            } else {
                arguments[0][i] += '&ver=' + clientexec.version;
            }
        } else {
            if (url.indexOf("?") < 0) {
                arguments[0][i] += '?ver=' + Math.random().toString(36).substring(2, 10);
            } else {
                arguments[0][i] += '&ver=' + Math.random().toString(36).substring(2, 10);
            }
        }
    }

    if (url.indexOf(".css") < 0) {
        return LazyLoad.js.apply(null, arguments);
    } else {
        return LazyLoad.css.apply(null, arguments);
    }

}

clientexec.updateCustomField = function(customfieldname, newvalue, staffid, callback)
{
    //if we are not passing a user to update the custom field for then assume
    //we are trying to update our own custom field
    if (typeof(staffid) == "undefined") staffid = clientexec.admin_id;
    if (typeof(callback) == "undefined") callback = function(){};
    $.ajax({
        url: "index.php?fuse=clients&controller=customfields&action=save",
        type: 'POST',
        data: {
            newvalue: newvalue,
            staffid: staffid,
            customfieldname: customfieldname
        },
        success: function(response) {
            callback(response);
        }
    });
};

clientexec.myNotes = function() {
    myNotesWindow = new RichHTML.window({
        url: 'index.php?fuse=admin&view=mynotes',
        actionUrl: 'index.php?fuse=admin&action=savenote',
        showSubmit: true,
        title: clientexec.lang("My Notes"),
        onSubmit: function(response) {
            clientexec.parseResponse(response);
        }
    });
    myNotesWindow.show();
}


profilenotes = {};
profilenotes.window = new RichHTML.window({
    url: 'index.php?fuse=clients&controller=notes&view=addnotes',
    actionUrl: 'index.php?fuse=clients&action=save&controller=notes',
    grid: profilenotes.table,
    showSubmit: true,
    title: clientexec.lang("Add Staff Note"),
});
clientexec.addNote = function(noteId) {
    if (profilenotes.table === 'undefined' ) {
        profilenotes.table = null
    }

    if (typeof noteId === 'undefined') {
        noteId = 0;
    }

    profilenotes.window.show({
        params:{
            id: noteId
        }
    });
};

emailcustomer = {};
clientexec.addEmailClient = function() {
    emailcustomer.window = new RichHTML.window({
        url: 'index.php?fuse=clients&controller=email&view=viewaddemail',
        actionUrl: 'index.php?fuse=clients&controller=email&action=sendemail',
        showSubmit: true,
        title: clientexec.lang("Email Client"),
        onSubmit: function(xhr) {
            if (xhr.error) {
                clientexec.error("There was an error sending the email: " + xhr.message);
            } else {
                clientexec.msg("email has been sent");
            }
        }
    });
    emailcustomer.window.show();
};

supportticket = {};
supportticket.ticketId = 0;
clientexec.addSupportTicket = function(a1,a2) {
    supportticket.window = new RichHTML.window({
        url: 'index.php?fuse=support&controller=ticket&view=viewaddticket',
        actionUrl: 'index.php?fuse=support&action=saveticket&controller=ticket&ignore=1',
        showSubmit: true,
        title: clientexec.lang("Add Support Ticket"),
        beforeSubmit: function() {
            if ($("#supportticket-tickettype").select2("val") === '') {
                var err = clientexec.lang("You must fill in all the required fields before submitting your ticket.");
                RichHTML.error(err);
                return false;
            }

            var formSelector = supportticket.window.form;
            var fileBlobs = [];
            var fileInputs = $("#file-upload-field");

            for (var i = 0; i < fileInputs.length; i++) {
                if ($("#file-upload-field").get(i).value) {
                    fileBlobs.push($("#file-upload-field").get(i).files[0]);
                }
            }

            if (fileBlobs.length == 0) {
                supportticket.window.options.actionUrl = 'index.php?fuse=support&action=saveticket&controller=ticket';
            } else {
                var url = 'index.php?fuse=support&action=saveticket&controller=ticket';
                var data = $(formSelector).serializeArray();
                $(formSelector).fileupload({url: url});
                $(formSelector).fileupload('send', {
                    files: fileBlobs,
                    formData: data
                }).done(function(res) {
                    if (res.success === true) {
                        supportticket.ticketId = res.ticketId;
                        window.location = 'index.php?fuse=support&id=' + supportticket.ticketId + '&view=ticket&controller=ticket';
                    }
                }).fail(function(res) {
                    var err = clientexec.lang("There was an c with this operation");
                    try {
                        var json = $.parseJSON(res.responseText);
                        err = json.message;
                    } catch(ex) {
                        // response is invalid json, but might still contain an error string
                        // (see issue #1024)
                        var matches = /"message":"(.*)"/.exec(res.responseText);
                        if (matches && matches[1]) {
                            err = matches[1];
                        }
                    }
                    RichHTML.error(err);
                });
            }
        },
        onSubmit: function(response) {
            if (response.success === true) {
                if (typeof response.ticketId !== 'undefined') {
                    supportticket.ticketId = response.ticketId;
                }
                if (supportticket.ticketId != 0) {
                    window.location = 'index.php?fuse=support&id=' + supportticket.ticketId + '&view=ticket&controller=ticket';
                }
            }
        }
    });
    supportticket.window.show();
};




// clientexec.hide_active_user_panel = function() {
//     if ($('#active-customer-panel').hasClass("pull-out")) {
//         $('#active-customer-panel').animate({right: "-304px" }, 300, function() {
//             $('#active-customer-panel').removeClass("pull-out");
//         });
//     }
// }

// clientexec.pin_active_user_panel = function() {
//     var session_vars;
//     if ($('body.with-active-cutomer-panel').length == 0) {

//         $('body').addClass('with-active-cutomer-panel');
//         $('#active-customer-panel').unbind('mouseenter mouseleave');
//         session_vars = {
//             showactivepanelstatus: 1
//         };

//     } else {
//         $('body').removeClass('with-active-cutomer-panel');
//         $('#active-customer-panel').hover(function(){$('#active-customer-panel').show();},clientexec.hide_active_user_panel);
//         session_vars = {
//             showactivepanelstatus: 0
//         };
//     }

//     $.ajax({
//         url: 'index.php?fuse=clients&action=updatesessionvar',
//         type: 'POST',
//         data: { fields : session_vars }
//     });
// }

clientexec.bindLinksIfLeavingInvoiceViewIsPrevented = function()
{
    //lets rebind this click event for invoicelist.. it is needed to prevent redirecting from view when there are changes made
    if (typeof (invoiceview) !== "undefined" && typeof(invoiceview.changesmade) !== "undefined" && invoiceview.changesmade) {
        $('a:not(.btn):not(.rich-button),div.accordion-group').unbind('click', invoiceview.clickanchorsafterchanges);
        $('a:not(.btn):not(.rich-button),div.accordion-group').bind('click', invoiceview.clickanchorsafterchanges);
    }
};


clientexec.populate_report = function (data, chart_id, args) {


    // defaults
    if (!chart_id) chart_id = "#myChartCanvas";
    args = args || {};

    // UI loading messages
    $('.report-title').html(
        '<i class="icon-spinner icon-spin icon-large me-2"></i>' +
        clientexec.lang("Loading Graph")
    );
    $('.report-description').text('');

    let sent_option_id = args.option_id || null;
    const addition_args = args ? "&" + $.param(args) : "";

    // parse "report-type" from original CE format
    const parts = data.split("-");
    const report = parts[0];
    const type = parts[1];

    const url =
        "index.php?fuse=reports&action=getreportgraph&graphdata=1" +
        "&report=" + report +
        "&type=" + type +
        addition_args;

    $.get(url, function (response) {

        const json = clientexec.parseResponse(response);
        if (!json.data) return;

        const linkUrl =
            'index.php?fuse=reports&view=viewreport&controller=index' +
            '&report=' + report +
            '&type=' + type;

        $('.report-title').html("<a href='" + linkUrl + "'>" + json.title + "</a>");
        $('.report-description').text(json.subtitle);

        const payload = JSON.parse(json.data);

        //---------------------------------------------------
        // PREPARE LABELS + DATASETS for Chart.js
        //---------------------------------------------------

        // y-axis formatting
        let yPrefix = "";
        let ySuffix = "";
        let yComma = false;

        if (payload.yType === "currency") {
            yPrefix = payload.yPre || "";
            yComma = payload.yFormat === "addcomma";
        } else if (payload.yType === "percent") {
            ySuffix = "%";
        }

        // Convert "main" datasets to Chart.js format
        const labels = [];
        const datasets = [];

        if (payload.main && payload.main.length > 0) {

            // Assume all datasets share the same X labels
            payload.main[0].data.forEach((point) => {
                labels.push(formatX(point.x, payload.xType));
            });

            payload.main.forEach((dataset, idx) => {

            // Determine dataset label
            let dsLabel = dataset.name;
            if (!dsLabel && dataset.className) {
                // Convert ".report_customer_status" → "Customer Status"
                dsLabel = dataset.className
                    .replace(/^\./, '')
                    .replace(/report_/, '')
                    .replace(/_/g, ' ')
                    .replace(/\b\w/g, l => l.toUpperCase());
            }
            if (!dsLabel) {
                dsLabel = "Series " + (idx + 1);
            }

            datasets.push({
                label: dsLabel,
                data: dataset.data.map(p => {
                    return {
                        x: formatX(p.x, payload.xType),
                        y: p.y,
                        tip: p.tip || null  // keep CE tooltip
                    };
                }),
                tension: (payload.type === "line" ? 0.3 : 0),
                borderWidth: 2,
                fill: false
            });
        });


        }

        //---------------------------------------------------
        // FORMATTERS
        //---------------------------------------------------

        function formatX(xVal, type) {
            if (type === "number") {
                return xVal;
            }

            // CE sometimes returns "XXXX-MM-DD" but with weird year formats
            const parsed = new Date(xVal);

            if (type === "daysofweek") {
                return parsed.toLocaleDateString(undefined, { weekday: 'long' });
            }

            // default: month name
            return parsed.toLocaleDateString(undefined, { month: 'long' });
        }

        function formatY(value) {
            const rounded = Number(value.toFixed(2));

            const formatted = yComma
                ? rounded.toLocaleString(undefined, {
                    minimumFractionDigits: 0,
                    maximumFractionDigits: 2
                })
                : rounded.toString();

            return yPrefix + formatted + ySuffix;
        }


        //---------------------------------------------------
        // CREATE CHART.JS CHART
        //---------------------------------------------------

        const canvas = document.querySelector(chart_id);
        if (!canvas) return;

        // Destroy old chart if exists
        if (window.myReportChart) {
            window.myReportChart.destroy();
        }

        window.myReportChart = new Chart(canvas.getContext('2d'), {
            type: (payload.type === "bar" ? "bar" : "line"),
            data: {
                labels: labels,
                datasets: datasets
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                interaction: { mode: 'index', intersect: false },
                plugins: {
                    tooltip: {
                        callbacks: {
                            label: function (ctx) {
                                return ctx.dataset.label + ": " + formatY(ctx.parsed.y);
                            }
                        }
                    },
                    legend: {
                        labels: { usePointStyle: true }
                    }
                },
                scales: {
                    y: {
                        ticks: {
                            callback: function (v) {
                                return formatY(v);
                            }
                        }
                    }
                }
            }
        });

        //---------------------------------------------------
        // REPORT OPTIONS (graph filters)
        //---------------------------------------------------

        $('.report_options').empty();

        if (response.options && response.options.label) {

            let html = `
                <div class="dropdown pull-right">
                    <a class="dropdown-toggle" data-bs-toggle="dropdown" href="#">
                        <span class="report_option_label">${response.options.label}</span>
                        <i class="bi bi-caret-down-fill ms-1"></i>
                    </a>
                    <ul class="dropdown-menu">
            `;

            $.each(response.options.values, function (name, value) {
                html += `
                    <li>
                        <a href="#" class="dropdown-item report-option-link"
                           data-graph-id="${report}-${type}"
                           data-option-id="${value}">
                           ${name}
                        </a>
                    </li>`;
            });

            html += "</ul></div>";

            $('.report_options').append($(html));

            // Update label to default/selected
            if (sent_option_id != null) {
                $('.report_option_label').text(
                    $('.report_options ul a[data-option-id="' + sent_option_id + '"]').text()
                );
            } else if (response.options.defaultid) {
                $('.report_option_label').text(
                    $('.report_options ul a[data-option-id="' + response.options.defaultid + '"]').text()
                );
            }

            // rebind click handlers
            $('.report-option-link')
                .off('click')
                .on('click', function (e) {
                    e.preventDefault();
                    clientexec.populate_report(
                        $(this).data('graph-id'),
                        chart_id,
                        { option_id: $(this).data('option-id') }
                    );
                    $('.report_option_label').text($(this).text());
                });
        }
    });
};


clientexec.showDashboardSettings = function() {
    dashSettings = new RichHTML.window({
        url: 'index.php?fuse=home&view=dashboardsettings',
        actionUrl: 'index.php?action=savedashboardsettings&fuse=home',
        showSubmit: true,
        title: clientexec.lang('Dashboard Settings'),
        onSubmit: function(response) {
            if (response.success === true) {
                const url = new URL(window.location.href);
                if (url.searchParams.get('fuse') === 'home' && url.searchParams.get('view') === 'dashboard') {
                    window.location = 'index.php?fuse=home&view=dashboard';
                }
            }
        }
    });
    dashSettings.show();
};


clientexec.nl2br = function(varTest){
    return varTest.replace(/(\r\n|\n\r|\r|\n)/g, "<br>");
};

clientexec.br2nl = function(varTest){
    return varTest.replace(/<br>/g, "\r");
};

clientexec.rmbr = function (string) {
    string = $('<textarea/>').html(string).text();
    string = string.replace(/<br\s*\/?>/gi, "\n");
    string = string.replace(/\r\n|\r/g, "\n");
    string = string.replace(/\n{3,}/g, "\n\n");

    return string;
};


clientexec.htmlDecode = function (string) {
    return $('<textarea/>').html(string).text();
};

clientexec.linkify = function(text) {
    var url_pattern = /(\()((?:ht|f)tps?:\/\/[a-z0-9\-._~!$&'()*+,;=:\/?#[\]@%]+)(\))|(\[)((?:ht|f)tps?:\/\/[a-z0-9\-._~!$&'()*+,;=:\/?#[\]@%]+)(\])|(\{)((?:ht|f)tps?:\/\/[a-z0-9\-._~!$&'()*+,;=:\/?#[\]@%]+)(\})|(<|&(?:lt|#60|#x3c);)((?:ht|f)tps?:\/\/[a-z0-9\-._~!$&'()*+,;=:\/?#[\]@%]+)(>|&(?:gt|#62|#x3e);)|((?:^|[^=\s'"\]])\s*['"]?|[^=\s]\s+)(\b(?:ht|f)tps?:\/\/[a-z0-9\-._~!$'()*+,;=:\/?#[\]@%]+(?:(?!&(?:gt|#0*62|#x0*3e);|&(?:amp|apos|quot|#0*3[49]|#x0*2[27]);[.!&',:?;]?(?:[^a-z0-9\-._~!$&'()*+,;=:\/?#[\]@%]|$))&[a-z0-9\-._~!$'()*+,;=:\/?#[\]@%]*)*[a-z0-9\-_~$()*+=\/#[\]@%])/img;
    var url_replace = '$1$4$7$10$13<a href="$2$5$8$11$14" rel="nofollow" target="_blank">$2$5$8$11$14</a>$3$6$9$12';
    return text.replace(url_pattern, url_replace);
};


clientexec.checkRedirectLogin = function(response) {
     try {
        if (typeof(response.redirectToLogin) != "undefined" && response.redirectToLogin) {
            window.location = 'index.php?fuse=admin&action=logout';
        }

    } catch(e) { }
};

clientexec.updateOnlineUsers = function(response) {
    if (!response.users) {
        return;
    }

    // Update the count if it has changed
    if (clientexec.whoisonline.userCount != response.count) {
        //we only want userCount to be online users
        clientexec.whoisonline.userCount = response.count;
    }

    $.each(response.users,function(index,objValue){
        if (objValue.id == clientexec.admin_id) {
            clientexec.whoisonline.me = objValue;
        }
    });

    clientexec.whoisonline.onlineusers = response.users;
    if( typeof(response.offlineusers) != "undefined" ){
         clientexec.whoisonline.offlineusers = response.offlineusers;
    }
};



clientexec.updateNotificationPanel = function (response) {
    let total = 0;

    if (response && response.length > 0) {
        $.each(response, function (i, obj) {
            const $el = $('#notification-panel .' + obj['menu-class']);
            if ($el.length) {
                $el.find('.fw-bold').text(parseInt(obj.count, 10) || 0);
                $el.attr('href', obj.link);
                total += parseInt(obj.count, 10) || 0;
            }
        });
    }
    $('.notification-wrap .count.red').text(total);
};

clientexec.dateRenderer = function (text, type) {
    // Let DataTables handle ordering/searching with raw data
    if (type !== 'display') {
        return text;
    }

    var newDate;
    if (!isNaN(text)) {
        newDate = new Date(text * 1000);
    } else {
        var components = /^(\d{4})-(\d{2})-(\d{2})$/.exec(text);
        if (components) {
            newDate = new Date(components[1], components[2] - 1, components[3]);
        } else {
            // already formatted
            return text;
        }
    }

    var y = newDate.getFullYear();
    var m = newDate.getMonth() + 1;
    if (m < 10) {
        m = '0' + m;
    }
    var d = newDate.getDate();
    if (d < 10) {
        d = '0' + d;
    }

    return clientexec.dateFormat === 'm/d/Y'
        ? m + '/' + d + '/' + y
        : d + '/' + m + '/' + y;
};

clientexec.tableActions = (function ($) {
    function setVisible($el, visible) {
        $el.toggleClass('d-none', !visible);
    }

    function closeDropdown($dd) {
        $dd.attr('data-open', 'false');
        $dd.find('.pill').attr('aria-expanded', 'false');
    }

    function closeAllDropdowns() {
        $('.table-actions .dropdown').each(function () {
            closeDropdown($(this));
        });
    }

    function setEnabled($pill, enabled) {
        $pill.prop('disabled', !enabled);
    }

    // Toggle dropdown
    $(document).on('click', '.table-actions .pill', function (e) {
        if (this.disabled) {
            return;
        }

        e.stopPropagation();

        const $dd = $(this).closest('.dropdown');
        const isOpen = $dd.attr('data-open') === 'true';

        clientexec.tableActions.closeAllDropdowns();

        if (isOpen) {
            return;
        }

        const $menu = $dd.find('.menu');

        // Reset placement first
        $dd.removeAttr('data-placement');

        // Measure available space
        const menuHeight = $menu.outerHeight();
        const rect = this.getBoundingClientRect();
        const spaceBelow = window.innerHeight - rect.bottom;
        const spaceAbove = rect.top;

        // Flip up only if needed
        if (spaceBelow < menuHeight && spaceAbove > menuHeight) {
            $dd.attr('data-placement', 'top');
        }

        $dd.attr('data-open', 'true');
        $(this).attr('aria-expanded', 'true');
    });


    // Click outside closes
    $(document).on('click', function () {
        closeAllDropdowns();
    });

    // Esc closes
    $(document).on('keydown', function (e) {
        if (e.key === 'Escape') {
            closeAllDropdowns();
        }
    });

    return {
        setVisible,
        closeDropdown,
        closeAllDropdowns,
        setEnabled
    };
})(jQuery);
