productview.addons = {};

productview.all_addons_load = function() {
    $('#product-tab-content').load('index.php?nolog=1&fuse=admin&controller=products&view=addonstab&groupid='+productview.groupid+'&productid='+productview.productid, productview.postloadactions_addons);
};

productview.postloadactions_addons = function(e)
{
    clientexec.postPageLoad('#product-tab-content');

    var table = $('#addons-list').DataTable({
        order: [
            [0, 'asc']
        ],
        searching: false,
        select: {
            style: 'multi',
            selector: 'td:first-child'
        },
        "ajax": {
            url: 'index.php?fuse=admin&controller=products&action=getaddonsforproduct&productid=' + productview.productid,
            dataSrc: 'addon',
        },
        rowReorder: {
            dataSrc: 0,
            selector: '.reorder-handle'
        },
        drawCallback: function () {
            document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(function (el) {
                new bootstrap.Tooltip(el);
            });
        },
        columnDefs: [
            { targets: 0, visible: false },
            {
                targets: 1,
                "orderable": false,
                className: 'select-checkbox',
                checkboxes: { selectRow: true },
                width: '1%'
            },
            {
                targets: 2,
                width: '5%',
                className: 'reorder-handle text-center',
                orderable: false,
                render: function () {
                    return '<i class="bi bi-grip-vertical"></i>';
                }
            }
        ],
          "columns": [
                { data: null, defaultContent: '', orderable: false, },
                { data: null, defaultContent: '', orderable: false, },
                { data: null, defaultContent: '', orderable: false, },
                {
                    "data": "name",
                    render: function (text, type, record) {
                        record.description = record.description.replace(/\"/g, "&quot;");
                        if (record.description) {
                            return '<span class="tip-target" data-bs-toggle="tooltip" data-bs-html="true" data-bs-placement="right" title="'
                                + record.description +
                                '" style="word-wrap:break-word;overflow:hidden;z-index:100">'
                                + record.name +
                                '</span>';
                        } else {
                            return record.name;
                        }

                    }
                },
                {
                    "data": "plugin_var",
                },
                {
                    "data": "type",
                    render: function (text, type, row) {
                         switch(row.type) {
                            case '0':
                                return clientexec.lang("Drop-down menus");
                            case '1':
                                return clientexec.lang("Radio buttons");
                             case '2':
                                return clientexec.lang("Quantity");
                        }
                    },
                },
            ],
    });

    table.on('select.dt deselect.dt', function() {
        var selectedRows = table.rows({ selected: true }).count();
        if (selectedRows > 0) {
            $('.table-actions .action-buttons').prop('disabled', false);
        } else {
            $('.table-actions .action-buttons').prop('disabled', true);
        }
    });

    table.on('row-reorder', function (e, diff, edit) {
        table.one('draw', function () {
            var newOrder = table.rows().ids().toArray();
              $.ajax({
                url: 'index.php?fuse=admin&controller=products&action=saveproductaddonorder&productid='+productview.productid,
                method: 'POST',
                data: { 'ids[]': newOrder },
                traditional: true,
            });
        });
    });

    $('#product-addons-toadd').on('change', function (e) {
        let val = $(this).val();

        if (val == -1 || val === null) {
            $('#btnAddAddon').prop('disabled', true);
        } else {
            $('#btnAddAddon').prop('disabled', false);
        }
    });

    $('#btnAddAddon').bind('click',function(e){
        e.preventDefault();
        RichHTML.msgBox('<b>'+clientexec.lang('WARNING!')+'</b>'+'<br><br><ul><li>'+clientexec.lang("If the addon is been added, existing clients will be applied the default value: 'None' option if available, or the first option if not.")+'</li><li>'+clientexec.lang("If the addon is been updated to quantity type, existing clients will use a quantity of 1 by default.")+'</li><li>'+clientexec.lang("If the addon is been updated from quantity type to a different type, existing clients will change their quantity to 1.")+'</li></ul>'+clientexec.lang('Are you sure you want to add/update the selected addon?'),
            {type:"yesno"}, function(result) {
                if(result.btn === clientexec.lang("Yes")) {
                    $.post("index.php?fuse=admin&controller=products&action=addaddontoproduct", {
                        productid:productview.productid,
                        id:$('#product-addons-toadd').val(),
                        type:$('#product-addons-type').val()
                    },
                    function(data){
                        data = clientexec.parseResponse(data);
                        table.ajax.reload();
                    });
                    $("#product-addons-toadd").select2("val", "-1");
                }
            });
    });

    $('#delete-button').bind('click',function(e){
        if ($(this).attr('disabled')) { return false; }
        e.preventDefault();
        RichHTML.msgBox('<b>'+clientexec.lang('NOTICE:')+'</b>'+'<br><br>'+clientexec.lang('Do you want existing clients to continue being charged this addon?'),
            {type:"confirm"}, function(result) {
                if(result.btn === clientexec.lang("Yes")) {
                    $.post("index.php?fuse=admin&controller=products&action=deleteaddonsfromproduct", {
                        keeprecurringfees:1,
                        productid:productview.productid,
                        ids:table.getSelectedRows()
                    },
                    function(data){
                        table.ajax.reload();
                    });
                }else if(result.btn === clientexec.lang("No")) {
                    $.post("index.php?fuse=admin&controller=products&action=deleteaddonsfromproduct", {
                        keeprecurringfees:0,
                        productid:productview.productid,
                        ids: table.getSelectedRows()
                    },
                    function(data){
                        table.ajax.reload();
                    });
                }
            });
    });

};
