productview.ssl_advanced_load = function() {
    $('#product-tab-content').load(
        'index.php?nolog=1&fuse=admin&controller=products&view=advancedtabforssl&groupid='
        + productview.groupid
        + '&productid='
        + productview.productid,
        productview.postloadactions_ssl_advanced
    );
};

productview.postloadactions_ssl_advanced = function() {

    // Init certificates select2
    $('#comboCertificates').select2({
        placeholder: productview.ssl.certificateText,
        minimumResultsForSearch: 3,
        width: 'resolve',
        ajax: {
            url: "index.php?fuse=admin&controller=products&action=getsslcerttypes&productid=" + productview.productid,
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    search: params.term || '',   // v4 uses params.term
                    registrar: $('#comboRegistrars').val()
                };
            },
            processResults: function(data) {
                let results = [];
                $(data.certificates).each(function() {
                    results.push({ id: this.id.toString(), text: this.name.toString() });
                });
                return { results: results };
            }
        }
    });

    // Set initial value (id + text)
    if (productview.ssl.certificateId && productview.ssl.certificateText) {
        let option = new Option(productview.ssl.certificateText, productview.ssl.certificateId, true, true);
        $('#comboCertificates').append(option).trigger('change');
    }

    clientexec.postPageLoad('#product-tab-content');

    // Registrar change
    $('#comboRegistrars').on('change', function() {
        $('#comboCertificates').prop('disabled', false);
        $('#comboCertificates').val(null).trigger('change'); // reset
    });

    // Submit
    $('.submit-ssl-advanced').on('click', function(e) {
        e.preventDefault();

        let certId   = $('#comboCertificates').val() || 0;
        let certText = $('#comboCertificates').find('option:selected').text() || '';
        let registrar = $('#comboRegistrars').val();

        // Allow cert to be 0 if no registrar
        if (certId == 0 && registrar != '-- None --') {
            RichHTML.msgBox("You must have a Cert Type selected before saving.", {type:'error'});
            return;
        }

        // Set to empty if "-- None --"
        if (registrar == '-- None --') {
            registrar = '';
        }

        $.ajax({
            url: 'index.php?fuse=admin&tab=general&controller=products&action=saveadvancedforssl&productid=' + productview.productid,
            type: 'POST',
            data: {
                certs: certId,
                certText: certText,
                registrar: registrar
            },
            success: function(xhr) {
                let json = clientexec.parseResponse(xhr);
            }
        });
    });

};
