$(document).ready(function () {
    viewinvoices.AcceptCCNumber = false;

    var ajaxUrl = 'index.php?fuse=billing&controller=invoice&action=getinvoices';
    var table = $('#invoices-list').DataTable({
        columnDefs: [{
            targets: 0,
            orderable: false,
            className: 'select-checkbox',
            checkboxes: {
                selectRow: true
            },
            width: '5%'
        }],

        select: {
            style: 'multi',
            selector: 'td:first-child'
        },

        processing: true,
        serverSide: true,
        "searching": false,
        "ajax": {
            url: ajaxUrl,
            data: function(d) {
                d.filterbydate = $('#filterByDate').val();
                d.startdate = formatDate($('#startdate').val());
                d.enddate = formatDate($('#enddate').val());
                d.invoicefilter = $('#filterByStatus').val();
                d.customerid = $('#invoice-userid').val();
            }
        },
        "columns": [
            { data: null, defaultContent: '', orderable: false, },
            {
                "className": 'details-control',
                "orderable": false,
                "data": null,
                "defaultContent": ''
            },
            {
                "data": "id",
                render: function (data, type, row) {
                    if (type === 'display') {
                        if ( viewinvoices.viewingFromProfile === true ) {
                            desc = "<a href='index.php?controller=invoice&fuse=billing&frmClientID="+row.customerid+"&view=invoice&invoiceid="+row.id+"&profile=1'>#"+row.id+"</a>";
                        } else {
                            desc = "<a href='index.php?controller=invoice&fuse=billing&frmClientID="+row.customerid+"&view=invoice&invoiceid="+row.id+"'>#"+data+"</a>";
                        }

                        return desc + "  <span class='invoicepdflink'><a href='index.php?sessionHash="+clientexec.sessionHash+"&fuse=billing&controller=invoice&action=generatepdfinvoice&invoiceid=" + row.invoiceid + "' target='_blank'><img class='pdfimage' src='../templates/admin/images/document-pdf-text.png' border='0' data-toggle='tooltip' title='"+ clientexec.lang('View PDF Invoice') +"' /></a></span>";
                    }

                    return data;
                }
            },
            {
                "data": "datecreated",
                render: clientexec.dateRenderer
            },
            {
                "data": "billdate",
                render: clientexec.dateRenderer
            },
            {
                "data": "customername",
                render: function (data, type, row) {
                    if (type === 'display') {
                        value = clientexec.htmlspecialchars(row.customername);

                        if ( viewinvoices.viewingFromProfile === true ) {
                            // we're viewing from the users profile, so only return their name
                            return value;
                        }

                        var filter = "";

                        if ($('#invoice-userid').val() == "") {
                            filter = '&nbsp;&nbsp;<span class="filter-invoice-user link ico-small" data-userid="'+row.customerid+'" data-icon="F"></span>';
                        }

                        return '<a href="index.php?fuse=clients&controller=userprofile&view=profilecontact&frmClientID=' + row.customerid + '">' + value + '</a>' + filter;
                    }

                    return data;
                }
            },
            {
                "data": "balancedue",
                render: function (data, type, row) {
                    if (type === 'display') {
                        var font_class = "";
                        var due = row.simplebalancedue;

                        return "<span class='"+font_class+"'>"+row.balancedue+"</span>";
                    }
                    return data;
                }
            },
            {
                "data": "amount",
                render: function (data, type, row) {
                    if (type === 'display') {
                        var font_class = "";
                        var due = row.simplebalancedue;

                        return "<span class='"+font_class+"'>"+row.amount+"</span>";
                    }
                    return data;
                }
            },
            {
                "data": "billstatus",
                render: function (data, type, row) {
                    return String.format('<span class="status-btn {1}">{0}</span>', row.billstatus, row.statusclass);
                },

            }
        ],
        "order": [[2, 'desc']]
    });


    // hide the client name col when viewing from profile
    if (viewinvoices.viewingFromProfile === true) {
        table.column(5).visible(false);
    }

    $('#invoices-list tbody').on('click', 'td.details-control', function () {
        var tr = $(this).closest('tr');
        var row = table.row(tr);

        if (row.child.isShown()) {
            row.child.hide();
            tr.removeClass('shown');
        }
        else {
            fetchRowDetails(row.data()).then(function (data) {
                var expanderBody = data.invoicetransactions;
                row.child(expanderBody).show();
                tr.addClass('shown');
            });
        }
    });

    function fetchRowDetails(row) {
        return new Promise((resolve, reject) => {
            $.get("index.php?fuse=billing&controller=invoice&action=getstyledinvoicetransactions", { invoiceid:row.invoiceid }, function(data) {})
            .done(resolve)
            .fail(reject);
        });
    }

    $('#checkAll').on('click', function () {
        if (this.checked) {
            table.rows({page: 'current'}).select();
        } else {
            table.rows().deselect();
        }
    });

    $('#filterByStatus').on('change', function () {
        if ($(this).val() == "3") {
            $('#invoice-userid').val('');
            $('#td-for-userid').show();
        } else {
            if (viewinvoices.viewingFromProfile == false) {
                $('#invoice-userid').val('');
            }
            $('#td-for-userid').hide();
            viewinvoices.disableButtons();
            table.ajax.reload();
        }
    });

    table.on('draw', function(object, data) {
        if(data.json.outstandingamount != ''){
            $('.filter-totals').html(clientexec.lang('Outstanding Amount') + ':&nbsp;&nbsp;' + data.json.outstandingamount.replace('<BR/>', '&nbsp;&nbsp;&nbsp;&nbsp;'));
        }else{
            $('.filter-totals').html('');
        }

        if ($('#filterByStatus').val() != 3 || $('#invoice-userid').val() !== '') {
            viewinvoices.addinvoicedescription($('#filterByStatus').val());
        }
    });

    viewinvoices.addinvoicedescription = function(filterid)
    {
        filterid = parseInt(filterid);
        var desc = "";

        switch(filterid) {
            case 0:
                desc =  clientexec.lang("Viewing all invoices that are past their due date, but not paid.");
                break;
            case 1:
                desc =  clientexec.lang("Viewing all invoices that have not been paid.");
                break;
            case 2:
                desc =  clientexec.lang("Viewing all invoices.");
                break;
            case 3:
                desc =  clientexec.lang("Viewing invoices for a filtered user.");
                break;
            case 4:
                desc =  clientexec.lang("Viewing pending invoices. Invoices that have been sent to a merchant but not cleared.  i.e. eChecks");
                break;
            case 5:
                desc =  clientexec.lang("Viewing all draft invoices. These invoices are not ready to be processed.");
                break;
            case -3:
                desc = clientexec.lang('Viewing all invoices that have not been sent.');
                break;
            case -2:
                desc = clientexec.lang('Viewing all failed invoices.');
                break;
             case 6:
                desc = clientexec.lang('Viewing all paid invoices.');
                break;
        }

        if (desc != "") {
            $('.filter-description').text(desc);
        }
    }

    $('#filterByDate, #startdate, #enddate, #invoice-userid').on('change', function () {
        viewinvoices.disableButtons();
        table.ajax.reload();
    });

    $("[id^='inv-']").click(function () {
        if ($(this).attr('disabled')) {
            return;
        }

        var id = $(this).attr('id');
        var selectedRows = table.rows({ selected: true }).data();

        switch (id) {
            case 'inv-cancelsub':
                RichHTML.msgBox(
                    clientexec.lang("Are sure you want to cancel the subscription tied to this invoice?"),
                    {
                        type: 'yesno'
                    },
                    function (ret) {
                        if (ret.btn == clientexec.lang("No")) {
                            return;
                        }

                        viewinvoices.disableButtons();
                        viewinvoices.performaction(id);
                    }
                );

                break;
            case 'inv-markpaid':
                RichHTML.msgBox(
                    clientexec.lang("Do you want to send a receipt?"),
                    {
                        type: 'confirm'
                    },
                    function (ret) {
                        var sendReceipt = false;

                        if (ret.btn == clientexec.lang("Yes")) {
                            sendReceipt = true;
                        } else if (ret.btn == clientexec.lang("Cancel")) {
                            return;
                        }

                        viewinvoices.disableButtons();
                        viewinvoices.performaction(id, {sendreceipt: sendReceipt});

                        return;
                    }
                );

                break;
            case 'inv-deleteinvoices':
                RichHTML.msgBox(
                    clientexec.lang("Are sure you want to delete the selected invoice(s)."),
                    {
                        type: 'yesno'
                    },
                    function (ret) {
                        if (ret.btn == clientexec.lang("No")) {
                            return;
                        }

                        viewinvoices.disableButtons();
                        viewinvoices.performaction(id);
                    }
                );

                break;
            case 'inv-varpayment':
                var balancedue = selectedRows[0].simplebalancedue;
                var rawbalancedue = selectedRows[0].rawbalancedue;

                RichHTML.msgBox(
                    '',
                    {
                        type: 'prompt',
                        content: clientexec.lang("Balance Due")+': '+balancedue+'<br/>'
                            +'<input type="text" id="paymentamount" name="paymentamount" class="required form-control" /><br/>'
                            +'<a href="#" id="addOptionalLink">'+clientexec.lang("Add optional information")+'</a>'
                            +'<fieldset class="editOptionalPopup" style="display:none">'
                            +'<a href="#"><i class="icon-remove-sign icon-large"></i>&nbsp&nbsp'+clientexec.lang("Remove Optional Information")+'</a>'
                            +'<div class="row-fluid">'
                            +clientexec.lang("Payment Reference (Optional)")+'<br/>'
                            +'<input class="form-control" type="text" name="checknum" id="checknum" /><br/><br/>'
                            +clientexec.lang("Payment Date (Optional)")+'<br/>'
                            +'<input class="form-control" type="date" name="paymentdate" id="paymentdate" /><br/>'
                            +clientexec.lang("Payment Time (Optional)")+'<br/>'
                            +'<input class="form-control" type="time" name="paymenttime" id="paymenttime" /><br/>'
                            +clientexec.lang("Payment Processor (Optional)")+'<br/>'
                            +'<input class="form-control" type="text" name="paymentprocessor" id="paymentprocessor" />'
                            +'</div>'
                            +'</fieldset>'
                    },
                    function (ret) {
                        if (ret.btn == clientexec.lang("Cancel")) {
                            return;
                        } else {
                            var priceformatted2 = ret.elements.paymentamount;
                            priceformatted2 = priceformatted2.toString();
                            var price = accounting.unformat(priceformatted2.replace(selectedRows[0].currency.symbol, ""), selectedRows[0].currency.decimalssep);
                            ret.elements.paymentamount = parseFloat(price);

                            if (ret.elements.paymentamount >= parseFloat(rawbalancedue)) {
                                RichHTML.msgBox(
                                    clientexec.lang("Do you want to send a receipt?"),
                                    {
                                        type: 'confirm'
                                    },
                                    function (ret2) {
                                        if (ret2.btn == clientexec.lang("Yes")) {
                                            var data = {sendreceipt: true};
                                            var args = ret.elements;
                                            args.paymentdate = formatDate(args.paymentdate);
                                            args.paymenttime = to12HourFormat(args.paymenttime);
                                            $.extend(data, args);
                                            viewinvoices.disableButtons();
                                            viewinvoices.performaction(id, data);
                                        } else if (ret2.btn == clientexec.lang("No")) {
                                            var data = {sendreceipt: false};
                                            var args = ret.elements;
                                            args.paymentdate = formatDate(args.paymentdate);
                                            args.paymenttime = to12HourFormat(args.paymenttime);
                                            $.extend(data, args);
                                            viewinvoices.disableButtons();
                                            viewinvoices.performaction(id, data);
                                        } else if (ret2.btn == clientexec.lang("Cancel")) {
                                            return;
                                        }
                                    }
                                );
                            } else {
                                var data = {sendreceipt: false};
                                var args = ret.elements;
                                args.paymentdate = formatDate(args.paymentdate);
                                args.paymenttime = to12HourFormat(args.paymenttime);
                                $.extend(data, args);
                                viewinvoices.disableButtons();
                                viewinvoices.performaction(id, data);
                            }
                        }
                    }
                );

                $('#paymentamount').unbind('keypress');
                $('#paymentamount').unbind('blur');
                $('#paymentamount').bind('keypress blur', function (event) {
                    //validate this field as allowing only float
                    if ((event.which == 13) || (event.type === "blur")) {
                        //lets check to see if the price was updated
                        var priceformatted2 = $(this).val();
                        priceformatted2 = priceformatted2.toString();
                        var price = accounting.unformat(priceformatted2.replace(selectedRows[0].currency.symbol, ""), selectedRows[0].currency.decimalssep);

                        if (selectedRows[0].currency.decimalssep === '&nbsp;') {
                            decimalssep = ' ';
                        } else {
                            decimalssep = selectedRows[0].currency.decimalssep;
                        }

                        if (selectedRows[0].currency.thousandssep === '&nbsp;') {
                            thousandssep = ' ';
                        } else {
                            thousandssep = selectedRows[0].currency.thousandssep;
                        }

                        $(this).val(accounting.formatMoney(price, "", selectedRows[0].currency.precision, thousandssep, decimalssep, selectedRows[0].currency.alignment));
                    }
                });

                $('#addOptionalLink').click(function () {
                    $(this).hide();
                    $(this).next().show();
                });

                $('.editOptionalPopup > a').click(function () {
                    $('.editOptionalPopup').hide();
                    $('#checknum').val('');
                    $('#paymentdate').val('');
                    $('#paymenttime').val('');
                    $('#paymentprocessor').val('');
                    $('#addOptionalLink').show();
                });

                break;
            case 'inv-process':
                var selectedRowData = selectedRows;
                var arrayLength = selectedRowData.length;
                var askAboutCharge = false;

                for (var idx = 0; idx < arrayLength; idx++) {
                    if (selectedRowData[idx].canbechargedtoday == 0) {
                        askAboutCharge = true;
                        break;
                    }
                }

                if (askAboutCharge) {
                    RichHTML.msgBox(
                        clientexec.lang("Some invoices are not due. Are you sure you want to proceed?"),
                        {
                            type: 'yesno'
                        },
                        function (result) {
                            if (result.btn === clientexec.lang("Yes")) {
                                //viewinvoices.AcceptCCNumber = false;
                                if (viewinvoices.AcceptCCNumber) {
                                    RichHTML.msgBox(
                                        clientexec.lang('Enter your passphrase:'),
                                        {
                                            type: 'prompt',
                                            password: true
                                        },
                                        function (result) {
                                            if (result.btn === clientexec.lang("OK")) {
                                                viewinvoices.disableButtons();
                                                viewinvoices.performaction(id, {passphrase: result.elements.value, acceptccnumber: viewinvoices.AcceptCCNumber});
                                            }
                                        }
                                    );
                                } else {
                                    viewinvoices.disableButtons();
                                    viewinvoices.performaction(id, {acceptccnumber: viewinvoices.AcceptCCNumber});
                                }
                            } else {
                                return;
                            }
                        }
                    );
                } else {
                    //viewinvoices.AcceptCCNumber = false;
                    if (viewinvoices.AcceptCCNumber) {
                        RichHTML.msgBox(
                            clientexec.lang('Enter your passphrase:'),
                            {
                                type: 'prompt',
                                password: true
                            },
                            function (result) {
                                if (result.btn === clientexec.lang("OK")) {
                                    viewinvoices.disableButtons();
                                    viewinvoices.performaction(id, {passphrase: result.elements.value, acceptccnumber: viewinvoices.AcceptCCNumber});
                                } else {
                                    return;
                                }
                            }
                        );
                    } else {
                        RichHTML.msgBox(
                            clientexec.lang("Are you sure you want to process the selected account(s)?"),
                            {
                                type: 'yesno'
                            },
                            function (result) {
                                if (result.btn === clientexec.lang("Yes")) {
                                    viewinvoices.disableButtons();
                                    viewinvoices.performaction(id, {acceptccnumber: viewinvoices.AcceptCCNumber});
                                } else {
                                    return;
                                }
                            }
                        );
                    }
                }

                break;
            default:
                //all other actions do not need confirmations or prompts
                viewinvoices.disableButtons();
                viewinvoices.performaction(id);

                break;
        }
    });

    viewinvoices.performaction = function (id, args) {
        var rowIds = table.getSelectedRows();

        var data = {
            items:        rowIds,
            itemstype:    'invoices',
            actionbutton: id
        };

        $.extend(data, args);

        $.ajax({
            url: "index.php?fuse=billing&controller=invoice&action=actoninvoice",
            type: 'POST',
            data:  data,
            success:  function (xhr) {
                clientexec.parseResponse(xhr);
                table.ajax.reload();

                if (typeof profile !== "undefined") {
                    setTimeout(function () {
                        profile.get_counts();
                    },1000);
                }
            }
        });
    };

    table.on('select.dt deselect.dt', function() {
        viewinvoices.disableButtons();

        var selectedRows = table.rows({ selected: true }).count();

        if (selectedRows > 0) {
            viewinvoices.enableButtons();
        }
    });

    function formatDate(dateString) {
        if (dateString == '') {
            return '';
        }

        date = new Date(dateString+'T12:00:00Z');
        options = {
            day:   "2-digit",
            month: "2-digit",
            year:  "numeric"
        };

        switch (clientexec.dateFormat) {
            case 'm/d/Y':
                newDate = new Intl.DateTimeFormat("en-US", options).format(date);
                break;
            case 'd/m/Y':
                newDate = new Intl.DateTimeFormat("en-GB", options).format(date);
                break;
        }

        return newDate;
    }

    function to12HourFormat(timeString) {
        if (timeString == '') {
            return '';
        }

        // Split "HH:mm" into hours & minutes
        const [hours, minutes] = timeString.split(":");

        // Create a Date object with today's date and the given time
        const date = new Date();
        date.setHours(parseInt(hours), parseInt(minutes));

        // Format with options
        return date.toLocaleTimeString(
            "en-US",
            {
                hour:   "2-digit",
                minute: "2-digit",
                hour12: true
            }
        );
    }

    viewinvoices.enableButtons = function () {
        const rowIds = table.getSelectedRows();

        $.ajax({
            url: "index.php?fuse=billing&controller=invoice&action=getinvoicebuttons",
            method: "GET",
            data: { invoices: rowIds },
            dataType: "json",
            success: function (data) {
                if (!data.buttons) {
                    return;
                }

                const $tableActions = $('.table-actions');

                // 1. Hide ALL actions first (menu items + standalone pills)
                $tableActions.find('.menu-item').addClass('d-none');
                $tableActions.find('.pill[id^="inv-"]').prop('disabled', true);

                // 2. Apply server response
                $.each(data.buttons, function (name, enabled) {
                    const selector = '#inv-' + name;
                    const $el = $(selector);

                    if (!$el.length) {
                        return;
                    }

                    if ($el.hasClass('menu-item')) {
                        clientexec.tableActions.setVisible($el, enabled);
                    } else if ($el.hasClass('pill')) {
                        clientexec.tableActions.setEnabled($el, enabled);
                    }
                });

                // 3. Enable dropdown pills that have visible menu items
                $tableActions.find('.dropdown').each(function () {
                    const $dd = $(this);
                    const $pill = $dd.find('.pill');
                    const hasVisibleItems =
                        $dd.find('.menu-item:not(.d-none)').length > 0;

                    clientexec.tableActions.setEnabled($pill, hasVisibleItems);

                    // Prevent stale open menus
                    clientexec.tableActions.closeDropdown($dd);
                });
            },
            error: function (xhr, status, error) {
                console.error('Error fetching invoice buttons:', error);
            }
        });
    };

    viewinvoices.disableButtons = function () {
        const $tableActions = $('.table-actions');

        // Disable all pills
        $tableActions.find('.pill').prop('disabled', true);

        // Hide all menu items
        $tableActions.find('.menu-item').addClass('d-none');

        // Close any open dropdowns
        clientexec.tableActions.closeAllDropdowns();
    };

    viewinvoices.disableButtons();
});